<?php

// Load Environment Variables
require_once __DIR__ . '/../core/Env.php';
Env::load(dirname(__DIR__, 2) . '/.env');

// App Configuration
define('APP_NAME', 'Cê Vai');
define('APP_URL', getenv('APP_URL') ?: 'http://localhost:8000');
define('APP_ENV', getenv('APP_ENV') ?: 'production');
define('DEBUG', getenv('DEBUG') === 'true');

// Error Reporting Logic
if (APP_ENV === 'production') {
  ini_set('display_errors', 0);
  ini_set('display_startup_errors', 0);
  error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);
} else {
  ini_set('display_errors', 1);
  ini_set('display_startup_errors', 1);
  error_reporting(E_ALL);
}

// Database Configuration
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_NAME', getenv('DB_NAME') ?: 'cevai');
define('DB_USER', getenv('DB_USER') ?: 'root');
define('DB_PASS', getenv('DB_PASS') ?: '');
define('DB_CHARSET', 'utf8mb4');

// Email Configuration (SMTP)
define('SMTP_HOST', getenv('SMTP_HOST') ?: 'smtp.example.com');
define('SMTP_PORT', getenv('SMTP_PORT') ?: 587);
define('SMTP_USER', getenv('SMTP_USER') ?: 'user@example.com');
define('SMTP_PASS', getenv('SMTP_PASS') ?: '');
define('SMTP_FROM', 'noreply@cevai.com');
define('SMTP_FROM_NAME', 'Cê Vai Tickets');

// Asaas API Configuration
define('ASAAS_API_KEY', getenv('ASAAS_API_KEY') ?: '');
define('ASAAS_URL', getenv('ASAAS_URL') ?: 'https://sandbox.asaas.com/api/v3');
define('ASAAS_WEBHOOK_TOKEN', getenv('ASAAS_WEBHOOK_TOKEN') ?: '');

// Pusher Configuration
define('PUSHER_APP_ID', getenv('PUSHER_APP_ID') ?: '');
define('PUSHER_KEY', getenv('PUSHER_KEY') ?: '');
define('PUSHER_SECRET', getenv('PUSHER_SECRET') ?: '');
define('PUSHER_CLUSTER', getenv('PUSHER_CLUSTER') ?: 'us2');

// Path Constants
define('ROOT_PATH', dirname(__DIR__, 2));
define('APP_PATH', ROOT_PATH . '/app');
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('VIEW_PATH', APP_PATH . '/views');

// Timezone
date_default_timezone_set('America/Sao_Paulo');
