<?php

class Database
{
  private $host;
  private $db_name;
  private $username;
  private $password;
  private $conn;

  public function connect()
  {
    $this->conn = null;

    $this->host = DB_HOST;
    $this->db_name = DB_NAME;
    $this->username = DB_USER;
    $this->password = DB_PASS;

    try {
      $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=" . DB_CHARSET;
      $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
      ];

      $this->conn = new PDO($dsn, $this->username, $this->password, $options);

      // Sync Timezone with PHP
      $offset = date('P'); // e.g., -03:00
      $this->conn->exec("SET time_zone = '$offset'");

    } catch (PDOException $e) {
      if (DEBUG) {
        echo "Connection Error: " . $e->getMessage();
      } else {
        echo "Database Connection Error.";
      }
      die();
    }

    return $this->conn;
  }
}
