<?php

class ClientController extends Controller
{

  public function __construct()
  {
    if (!isset($_SESSION['user_role'])) {
      $this->redirect('/login');
    }

    // Lazy expire check
    $orderModel = $this->model('Order');
    $orderModel->cancelExpiredPending(10); // 10 minutes
  }

  public function dashboard()
  {
    $userId = $_SESSION['user_id'];
    $userTicketModel = $this->model('UserTicket');
    $tickets = $userTicketModel->getByUserId($userId);

    $userModel = $this->model('User');
    $user = $userModel->findById($userId);

    $this->view('client/dashboard', ['tickets' => $tickets, 'user' => $user]);
  }

  public function tickets()
  {
    $userId = $_SESSION['user_id'];
    $userTicketModel = $this->model('UserTicket');
    $tickets = $userTicketModel->getByUserId($userId);

    $this->view('client/tickets', ['tickets' => $tickets]);
  }

  public function profile()
  {
    $userId = $_SESSION['user_id'];
    $userModel = $this->model('User');
    $user = $userModel->findById($userId); // Need simple findById in User model

    $this->view('client/profile', ['user' => $user]);
  }

  public function viewTicket($uniqueCode)
  {
    $userTicketModel = $this->model('UserTicket');
    $ticket = $userTicketModel->findByCode($uniqueCode);

    if (!$ticket || $ticket['user_id'] != $_SESSION['user_id']) {
      $this->redirect('/client/dashboard?error=not_found');
      return;
    }

    $this->view('client/ticket_view', ['ticket' => $ticket]);
  }

  public function updateProfile()
  {
    $userId = $_SESSION['user_id'];
    $data = [
      'name' => filter_input(INPUT_POST, 'name', FILTER_SANITIZE_SPECIAL_CHARS),
      'phone' => filter_input(INPUT_POST, 'phone', FILTER_SANITIZE_SPECIAL_CHARS),
      'password' => $_POST['password']
    ];

    $userModel = $this->model('User');
    if ($userModel->update($userId, $data)) {
      $this->redirect('/client/profile?msg=atualizado');
    } else {
      die("Erro ao atualizar perfil");
    }
  }
}
