<?php

class WebhookController extends Controller
{
  public function handle()
  {
    // 1. Security Check (Signature Verification)
    $headers = getallheaders();
    $receivedToken = $headers['asaas-access-token'] ?? $headers['Asaas-Access-Token'] ?? '';

    // Check if token matches .env config
    $valid = false;
    if ($receivedToken === ASAAS_WEBHOOK_TOKEN) {
      $valid = true;
    } else {
      // Fallback: Check Database Settings
      require_once APP_PATH . '/models/Setting.php';
      $settingModel = new Setting();
      $dbToken = $settingModel->get('asaas_webhook_token');
      if ($dbToken && $receivedToken === $dbToken) {
        $valid = true;
      }
    }

    if (!$valid) {
      http_response_code(401);
      echo "Unauthorized";
      error_log("Webhook Security Alert: Invalid Token received. IP: " . $_SERVER['REMOTE_ADDR']);
      return;
    }

    // 2. Receive Payload
    $jsonData = file_get_contents('php://input');
    $data = json_decode($jsonData, true);

    if (!$data || !isset($data['event'])) {
      http_response_code(400);
      echo "Invalid Payload";
      return;
    }

    $event = $data['event'];
    $payment = $data['payment'];

    // We used externalReference to store Order ID
    $orderId = $payment['externalReference'] ?? null;

    if (!$orderId) {
      // Maybe log this?
      http_response_code(200); // Acknowledge anyway
      return;
    }

    require_once APP_PATH . '/services/EmailService.php';

    // 2. Process Event
    if ($event === 'PAYMENT_CONFIRMED' || $event === 'PAYMENT_RECEIVED') {

      $orderModel = $this->model('Order');
      $userTicketModel = $this->model('UserTicket');
      $order = $orderModel->findById($orderId);

      if ($order && $order['payment_status'] !== 'paid') {
        // Update Order
        $orderModel->updateStatus($orderId, 'paid');

        // Activate Tickets
        $userTicketModel->activateByOrderId($orderId);

        // Send Email
        // We need User info and Ticket Code.
        // Fetch items
        $tickets = $userTicketModel->getByUserId($order['user_id']);
        // This fetches ALL tickets. We need tickets for THIS order.
        // But UserTicket doesn't have getByOrderId helper except for internal usage?
        // Order Model has getItemsByOrder!
        $items = $orderModel->getItemsByOrder($orderId);

        if (!empty($items)) {
          $uniqueCode = $items[0]['unique_code'];
          $userModel = $this->model('User');
          $user = $userModel->findById($order['user_id']);

          $ticketModel = $this->model('TicketType');
          $eventModel = $this->model('Event');

          // Fetch Ticket to get Event ID (since items only have event_title currently)
          // Ideally items should have event_id, but we can relay on ticket_type_id
          $ticket = $ticketModel->findById($items[0]['ticket_type_id']);
          $eventData = [];
          if ($ticket) {
            $eventData = $eventModel->findById($ticket['event_id']);
          }
          if (!$eventData) {
            $eventData = ['title' => $items[0]['event_title'] ?? 'Evento'];
          }

          $emailService = new EmailService();
          $emailService->sendTicketPurchased($user['email'], $user['name'], $eventData, $uniqueCode);
        }
      }
    }

    // 3. Response
    http_response_code(200);
    echo json_encode(['status' => 'success']);
  }
}
