<?php

class Controller
{
  public function view($view, $data = [])
  {
    // Extract data to variables
    extract($data);

    // Check if view file exists
    // Views can be in subfolders, passed as 'folder/file'
    $viewFile = VIEW_PATH . '/' . $view . '.php';

    if (file_exists($viewFile)) {
      require_once $viewFile;
    } else {
      die("View does not exist: " . $view);
    }
  }

  public function model($model)
  {
    require_once APP_PATH . '/models/' . $model . '.php';
    return new $model();
  }

  public function redirect($url)
  {
    header("Location: " . APP_URL . $url);
    exit;
  }
}
