<?php

class Speaker extends Model
{
  public function create($data)
  {
    $sql = "INSERT INTO speakers (event_id, name, role, image_url, bio) VALUES (:event_id, :name, :role, :image_url, :bio)";
    $stmt = $this->conn->prepare($sql);
    $stmt->bindValue(':event_id', $data['event_id']);
    $stmt->bindValue(':name', $data['name']);
    $stmt->bindValue(':role', $data['role']);
    $stmt->bindValue(':image_url', $data['image_url']);
    $stmt->bindValue(':bio', $data['bio']);
    return $stmt->execute();
  }

  public function getByEventId($eventId)
  {
    $stmt = $this->conn->prepare("SELECT * FROM speakers WHERE event_id = :event_id");
    $stmt->bindValue(':event_id', $eventId);
    $stmt->execute();
    return $stmt->fetchAll();
  }

  public function delete($id)
  {
    $stmt = $this->conn->prepare("DELETE FROM speakers WHERE id = :id");
    $stmt->bindValue(':id', $id);
    return $stmt->execute();
  }
}
