<?php

class TicketType extends Model
{

  public function getByEventId($eventId)
  {
    $stmt = $this->conn->prepare("SELECT * FROM ticket_types WHERE event_id = :event_id AND is_active = 1");
    $stmt->bindParam(':event_id', $eventId);
    $stmt->execute();
    return $stmt->fetchAll();
  }

  public function findById($id)
  {
    $stmt = $this->conn->prepare("SELECT * FROM ticket_types WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    return $stmt->fetch();
  }

  public function create($data)
  {
    $sql = "INSERT INTO ticket_types (event_id, name, batch_name, price, promotional_price, total_quantity, available_quantity, promotion_start_date, promotion_end_date, is_active) 
                VALUES (:event_id, :name, :batch_name, :price, :promotional_price, :total_quantity, :available_quantity, :promotion_start_date, :promotion_end_date, :is_active)";

    $stmt = $this->conn->prepare($sql);

    $stmt->bindValue(':event_id', $data['event_id']);
    $stmt->bindValue(':name', $data['name']);
    $stmt->bindValue(':batch_name', $data['batch_name']);
    $stmt->bindValue(':price', $data['price']);
    $stmt->bindValue(':promotional_price', $data['promotional_price'] ?: NULL); // Handle empty as NULL
    $stmt->bindValue(':total_quantity', $data['total_quantity']);
    $stmt->bindValue(':available_quantity', $data['total_quantity']); // Start with total
    $stmt->bindValue(':promotion_start_date', $data['promotion_start_date'] ?: NULL);
    $stmt->bindValue(':promotion_end_date', $data['promotion_end_date'] ?: NULL);
    $stmt->bindValue(':is_active', 1);

    return $stmt->execute();
  }

  public function decrementStock($id)
  {
    $sql = "UPDATE ticket_types SET available_quantity = available_quantity - 1 WHERE id = :id AND available_quantity > 0";
    $stmt = $this->conn->prepare($sql);
    $stmt->bindValue(':id', $id);
    $stmt->execute();
    return $stmt->rowCount() > 0;
  }

  public function update($id, $data)
  {
    $sql = "UPDATE ticket_types SET name = :name, batch_name = :batch_name, price = :price, promotional_price = :promotional_price, total_quantity = :total_quantity, promotion_start_date = :promotion_start_date, promotion_end_date = :promotion_end_date, is_active = :is_active WHERE id = :id";

    $stmt = $this->conn->prepare($sql);

    $stmt->bindValue(':name', $data['name']);
    $stmt->bindValue(':batch_name', $data['batch_name']);
    $stmt->bindValue(':price', $data['price']);
    $stmt->bindValue(':promotional_price', $data['promotional_price'] ?: NULL);
    $stmt->bindValue(':total_quantity', $data['total_quantity']);
    $stmt->bindValue(':promotion_start_date', $data['promotion_start_date'] ?: NULL);
    $stmt->bindValue(':promotion_end_date', $data['promotion_end_date'] ?: NULL);
    $stmt->bindValue(':is_active', isset($data['is_active']) ? $data['is_active'] : 1);
    $stmt->bindValue(':id', $id);

    return $stmt->execute();
  }

  public function delete($id)
  {
    $stmt = $this->conn->prepare("DELETE FROM ticket_types WHERE id = :id");
    $stmt->bindParam(':id', $id);
    return $stmt->execute();
  }
}
