<?php

class User extends Model
{
  public function count()
  {
    $stmt = $this->conn->query("SELECT COUNT(*) FROM users");
    return $stmt->fetchColumn();
  }

  public function getAll()
  {
    $stmt = $this->conn->query("SELECT * FROM users WHERE role = 'client' ORDER BY created_at DESC");
    return $stmt->fetchAll();
  }

  public function getAllOperators()
  {
    $stmt = $this->conn->query("SELECT * FROM users WHERE role = 'operator' ORDER BY name ASC");
    return $stmt->fetchAll();
  }

  public function findByEmail($email)
  {
    $stmt = $this->conn->prepare("SELECT * FROM users WHERE email = :email");
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    return $stmt->fetch();
  }

  public function updateRole($id, $role)
  {
    $stmt = $this->conn->prepare("UPDATE users SET role = :role WHERE id = :id");
    $stmt->bindValue(':role', $role);
    $stmt->bindValue(':id', $id);
    return $stmt->execute();
  }

  public function create($name, $email, $password, $cpf, $phone, $isActive = 1, $activationToken = null)
  {
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $this->conn->prepare("INSERT INTO users (name, email, password, cpf, phone, is_active, activation_token) VALUES (:name, :email, :password, :cpf, :phone, :is_active, :token)");
    $stmt->bindParam(':name', $name);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':password', $hash);
    $stmt->bindParam(':cpf', $cpf);
    $stmt->bindParam(':phone', $phone);
    $stmt->bindValue(':is_active', $isActive);
    $stmt->bindValue(':token', $activationToken);

    if ($stmt->execute()) {
      return $this->conn->lastInsertId();
    }
    return false;
  }

  public function activateAccount($token)
  {
    $stmt = $this->conn->prepare("UPDATE users SET is_active = 1, activation_token = NULL, email_verified_at = NOW() WHERE activation_token = :token");
    $stmt->bindParam(':token', $token);
    return $stmt->execute() && $stmt->rowCount() > 0;
  }

  public function findById($id)
  {
    $stmt = $this->conn->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    return $stmt->fetch();
  }

  public function update($id, $data)
  {
    $sql = "UPDATE users SET name = :name, email = :email, phone = :phone";

    if (!empty($data['password'])) {
      $sql .= ", password = :password";
    }

    $sql .= " WHERE id = :id";

    $stmt = $this->conn->prepare($sql);
    $stmt->bindValue(':name', $data['name']);
    $stmt->bindValue(':email', $data['email']);
    $stmt->bindValue(':phone', $data['phone']);
    $stmt->bindValue(':id', $id);

    if (!empty($data['password'])) {
      $hash = password_hash($data['password'], PASSWORD_DEFAULT);
      $stmt->bindValue(':password', $hash);
    }

    return $stmt->execute();
  }

  public function saveAsaasCustomerId($userId, $customerId)
  {
    $stmt = $this->conn->prepare("UPDATE users SET asaas_customer_id = :customer_id WHERE id = :id");
    $stmt->bindValue(':customer_id', $customerId);
    $stmt->bindValue(':id', $userId);
    return $stmt->execute();
  }

  public function delete($id)
  {
    $stmt = $this->conn->prepare("DELETE FROM users WHERE id = :id");
    $stmt->bindParam(':id', $id);
    return $stmt->execute();
  }
}
