<?php

require_once APP_PATH . '/../vendor/autoload.php';

class PusherService
{
  private $pusher;

  public function __construct()
  {
    $options = [
      'cluster' => PUSHER_CLUSTER,
      'useTLS' => true
    ];

    $this->pusher = new Pusher\Pusher(
      PUSHER_KEY,
      PUSHER_SECRET,
      PUSHER_APP_ID,
      $options
    );
  }

  public function trigger($channel, $event, $data)
  {
    try {
      return $this->pusher->trigger($channel, $event, $data);
    } catch (Exception $e) {
      error_log("Pusher Error: " . $e->getMessage());
      return false;
    }
  }
}
