<?php
$title = 'Check-in de Ingressos - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-xl mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
  <h2 class="text-3xl font-bold mb-6 text-brand-neon">Check-in</h2>

  <?php if (isset($data['success'])): ?>
    <div
      class="bg-green-100 dark:bg-green-500/20 border border-green-500 text-green-700 dark:text-green-100 p-4 rounded mb-6 text-center">
      <h3 class="font-bold text-xl">Ingresso Validado!</h3>
      <p>Participante: <?php echo htmlspecialchars($data['ticket']['user_name']); ?></p>
      <p>Ingresso: <?php echo htmlspecialchars($data['ticket']['ticket_name']); ?></p>
    </div>
  <?php elseif (isset($data['error'])): ?>
    <div
      class="bg-red-100 dark:bg-red-500/20 border border-red-500 text-red-700 dark:text-red-100 p-4 rounded mb-6 text-center">
      <h3 class="font-bold text-xl">Erro!</h3>
      <p><?php echo htmlspecialchars($data['error']); ?></p>
    </div>
  <?php endif; ?>

  <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>

  <div class="mb-6">
    <div id="reader" class="rounded-lg overflow-hidden border border-gray-700 bg-black min-h-[300px] relative hidden">
      <video id="qr-video" class="w-full h-full object-cover"></video>
      <div class="absolute inset-0 flex items-center justify-center pointer-events-none">
        <div class="w-64 h-64 border-2 border-brand-neon rounded-lg opacity-50"></div>
      </div>
    </div>

    <div id="scan-controls" class="text-center">
      <button id="start-scan" type="button"
        class="bg-gray-800 text-white px-6 py-4 rounded-xl flex items-center justify-center gap-2 mx-auto hover:bg-gray-700 transition w-full md:w-auto">
        <i class="fas fa-camera text-xl"></i>
        <span class="font-bold">Abrir Câmera</span>
      </button>
      <button id="stop-scan" type="button"
        class="hidden bg-red-600 text-white px-6 py-2 rounded-lg items-center gap-2 mx-auto hover:bg-red-700 transition mt-2">
        Parar Câmera
      </button>
      <p id="camera-error" class="text-red-500 mt-2 hidden text-sm font-bold"></p>
    </div>
  </div>

  <form action="/admin/checkin/process" method="POST" class="space-y-4">
    <?php echo Helpers::csrf_field(); ?>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Código do Ingresso</label>
      <input type="text" id="ticketCode" name="code" placeholder="TICKET-XXXXXX"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-4 text-gray-900 dark:text-white text-center text-xl uppercase tracking-widest outline-none focus:border-brand-secondary dark:focus:border-brand-neon transition">
    </div>
    <button type="submit"
      class="w-full bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold py-3 rounded hover:brightness-110 transition transform hover:scale-105 shadow-md">
      VALIDAR LIBERAÇÃO
    </button>
  </form>

  <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
  <script>
    document.addEventListener('DOMContentLoaded', () => {
      const html5QrCode = new Html5Qrcode("reader");
      const startBtn = document.getElementById('start-scan');
      const stopBtn = document.getElementById('stop-scan');
      const readerEl = document.getElementById('reader');
      const errorMsg = document.getElementById('camera-error');
      const ticketInput = document.getElementById('ticketCode');

      // Check if HTTPS is being used (required for camera on non-localhost)
      const isLocalhost = window.location.hostname === 'localhost' || window.location.hostname === '127.0.0.1';
      const isHttps = window.location.protocol === 'https:';

      if (!isHttps && !isLocalhost) {
        errorMsg.textContent = "A câmera requer HTTPS para funcionar (exceto em localhost).";
        errorMsg.classList.remove('hidden');
        startBtn.disabled = true;
        startBtn.classList.add('opacity-50', 'cursor-not-allowed');
      }

      startBtn.addEventListener('click', () => {
        errorMsg.classList.add('hidden');
        readerEl.classList.remove('hidden');

        // Config: Prefer back camera
        const config = { fps: 10, qrbox: { width: 250, height: 250 } };

        html5QrCode.start(
          { facingMode: "environment" },
          config,
          (decodedText, decodedResult) => {
            // Success
            console.log(`Scan success: ${decodedText}`);
            ticketInput.value = decodedText;

            // Audio feedback
            const audio = new Audio('https://assets.mixkit.co/active_storage/sfx/2573/2573-preview.mp3');
            audio.play().catch(e => console.log('Audio error:', e));

            // Stop scanning automatically on success
            stopScanning();

            // Auto submit option (uncomment if desired)
            // document.querySelector('form').submit();
          },
          (errorMessage) => {
            // parse error, ignore it.
          }
        ).then(() => {
          startBtn.classList.add('hidden');
          stopBtn.classList.remove('hidden');
          stopBtn.style.display = 'inline-flex';
        }).catch((err) => {
          console.log(err);
          readerEl.classList.add('hidden');
          errorMsg.textContent = "Erro ao acessar câmera. Verifique as permissões.";
          errorMsg.classList.remove('hidden');
        });
      });

      stopBtn.addEventListener('click', stopScanning);

      function stopScanning() {
        html5QrCode.stop().then(() => {
          readerEl.classList.add('hidden');
          startBtn.classList.remove('hidden');
          stopBtn.classList.add('hidden');
        }).catch((err) => {
          console.log("Failed to stop.", err);
        });
      }
    });
  </script>

  <div class="mt-8 text-center">
    <a href="/admin/dashboard" class="text-gray-500 hover:text-gray-900 dark:hover:text-white">Voltar ao Painel</a>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>