<?php
$title = 'Gerenciar Clientes - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-6xl mx-auto">
  <h2 class="text-3xl font-bold mb-8 text-brand-secondary dark:text-brand-neon">Gerenciar Clientes</h2>

  <div
    class="bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 overflow-x-auto shadow-sm dark:shadow-none">
    <table class="w-full text-left">
      <thead>
        <tr class="bg-gray-100 dark:bg-gray-800 text-gray-500 dark:text-gray-400">
          <th class="p-4">Nome</th>
          <th class="p-4">Email</th>
          <th class="p-4">Telefone</th>
          <th class="p-4">CPF</th>
          <th class="p-4">Cadastro</th>
          <th class="p-4 text-right">Ações</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
        <?php if (empty($data['clients'])): ?>
          <tr>
            <td colspan="6" class="p-8 text-center text-gray-500">Nenhum cliente cadastrado.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($data['clients'] as $client): ?>
            <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50">
              <td class="p-4 font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($client['name']); ?></td>
              <td class="p-4 text-gray-600 dark:text-gray-400"><?php echo htmlspecialchars($client['email']); ?></td>
              <td class="p-4 text-gray-600 dark:text-gray-400"><?php echo htmlspecialchars($client['phone'] ?? '-'); ?></td>
              <td class="p-4 text-gray-600 dark:text-gray-400"><?php echo htmlspecialchars($client['cpf'] ?? '-'); ?></td>
              <td class="p-4 text-gray-500 text-sm"><?php echo date('d/m/Y', strtotime($client['created_at'])); ?></td>
              <td class="p-4 text-right space-x-2">
                <a href="/admin/clients/edit?id=<?php echo $client['id']; ?>"
                  class="text-blue-600 dark:text-blue-400 hover:underline text-sm">Editar</a>
                <a href="/admin/clients/delete?id=<?php echo $client['id']; ?>"
                  class="text-red-600 dark:text-red-500 hover:underline text-sm"
                  onclick="return confirm('Tem certeza que deseja excluir este cliente?');">Excluir</a>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>