<?php
$title = 'Painel Admin - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="space-y-6">

    <!-- Filters Section -->
    <div
        class="bg-white dark:bg-gray-900 p-4 rounded-lg border border-gray-200 dark:border-gray-800 flex flex-wrap gap-4 items-center justify-between shadow-sm dark:shadow-none">
        <h3 class="text-gray-900 dark:text-white font-bold text-sm uppercase tracking-wider hidden md:block">Filtros
        </h3>
        <form action="/admin/dashboard" method="GET" class="flex flex-wrap gap-2 items-center flex-1">
            <select name="event_id"
                class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 text-sm focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                onchange="this.form.submit()">
                <option value="">Todos os Eventos</option>
                <?php foreach ($events as $evt): ?>
                    <option value="<?php echo $evt['id']; ?>" <?php echo ($filters['event_id'] ?? '') == $evt['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($evt['title']); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <?php if (!empty($tickets)): ?>

                <select name="ticket_id"
                    class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 text-sm focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                    onchange="this.form.submit()">
                    <option value="">Todos os Ingressos</option>
                    <?php foreach ($tickets as $tkt): ?>
                        <option value="<?php echo $tkt['id']; ?>" <?php echo ($filters['ticket_id'] ?? '') == $tkt['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($tkt['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            <?php endif; ?>

            <div class="flex items-center gap-2">
                <input type="text" name="start_date" id="start_date" placeholder="Data Inicial"
                    value="<?php echo $filters['start_date'] ?? ''; ?>"
                    class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 text-sm focus:border-brand-secondary dark:focus:border-brand-neon outline-none w-32 flatpickr-input">
                <span class="text-gray-500">-</span>
                <input type="text" name="end_date" id="end_date" placeholder="Data Final"
                    value="<?php echo $filters['end_date'] ?? ''; ?>"
                    class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 text-sm focus:border-brand-secondary dark:focus:border-brand-neon outline-none w-32 flatpickr-input">
            </div>

            <?php if (!empty($filters['event_id']) || !empty($filters['ticket_id']) || !empty($filters['start_date'])): ?>
                <a href="/admin/dashboard" class="text-xs text-brand-purple hover:underline ml-2">Limpar</a>
            <?php endif; ?>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            flatpickr(".flatpickr-input", {
                dateFormat: "Y-m-d",
                altInput: true,
                altFormat: "d/m/Y",
                theme: "dark",
                locale: "pt",
                onChange: function (selectedDates, dateStr, instance) {
                    instance.element.form.submit();
                }
            });
        });
    </script>

    <!-- KPI Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
        <div
            class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 relative overflow-hidden group shadow-sm dark:shadow-none">
            <div
                class="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition text-brand-secondary dark:text-brand-neon">
                <svg class="w-16 h-16" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4z" />
                    <path fill-rule="evenodd"
                        d="M18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z"
                        clip-rule="evenodd" />
                </svg>
            </div>
            <h4 class="text-gray-500 text-xs font-bold uppercase tracking-wider">Faturamento</h4>
            <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1">R$
                <?php echo number_format($stats['revenue'], 2, ',', '.'); ?>
            </p>
        </div>

        <div
            class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 relative overflow-hidden group shadow-sm dark:shadow-none">
            <div class="absolute top-0 right-0 p-4 opacity-10 group-hover:opacity-20 transition text-blue-500">
                <svg class="w-16 h-16" fill="currentColor" viewBox="0 0 20 20">
                    <path
                        d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z" />
                </svg>
            </div>
            <h4 class="text-gray-500 text-xs font-bold uppercase tracking-wider">Pedidos</h4>
            <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1"><?php echo $stats['orders']; ?></p>
        </div>

        <div
            class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
            <h4 class="text-gray-500 text-xs font-bold uppercase tracking-wider">Eventos Ativos</h4>
            <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1"><?php echo $stats['events']; ?></p>
        </div>

        <div
            class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
            <h4 class="text-gray-500 text-xs font-bold uppercase tracking-wider">Usuários</h4>
            <p class="text-2xl font-bold text-gray-900 dark:text-white mt-1"><?php echo $stats['users']; ?></p>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Lines: Sales over time -->
        <div
            class="lg:col-span-2 bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
            <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">Vendas (Últimos 30 dias)</h3>
            <div class="h-64">
                <canvas id="salesChart"></canvas>
            </div>
        </div>

        <!-- Doughnut: Sales distribution -->
        <div
            class="lg:col-span-1 bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
            <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">Distribuição</h3>
            <div class="h-64 relative">
                <canvas id="distributionChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Check-in Stats Charts -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Pie: Overall Rate -->
        <div
            class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
            <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">Taxa de Check-in</h3>
            <div class="h-64 relative">
                <canvas id="checkinPieChart"></canvas>
            </div>
        </div>

        <!-- Bar: By Event -->
        <div
            class="md:col-span-2 bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
            <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">Check-in vs Vendas (Por Evento)</h3>
            <div class="h-64">
                <canvas id="checkinChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Recent Orders Table -->
    <div
        class="bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 overflow-hidden shadow-sm dark:shadow-none">
        <!-- ... (rest of table) ... -->
    </div>
</div>

<!-- Scripts for Charts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Helper to safely output JSON
    const safeJson = (data) => {
        try {
            return JSON.parse(data);
        } catch (e) {
            console.error('JSON Parse Error:', e);
            return [];
        }
    };

    // Dynamic Colors from Settings
    const BRAND_NEON = '<?php echo $settings['color_brand_neon'] ?? '#00F3FF'; ?>';
    const BRAND_SECONDARY = '<?php echo $settings['color_brand_secondary'] ?? '#7000FF'; ?>';

    // Helper: Hex to RGBA
    function hexToRgba(hex, alpha) {
        let r = 0, g = 0, b = 0;
        if (hex.length == 4) {
            r = "0x" + hex[1] + hex[1];
            g = "0x" + hex[2] + hex[2];
            b = "0x" + hex[3] + hex[3];
        } else if (hex.length == 7) {
            r = "0x" + hex[1] + hex[2];
            g = "0x" + hex[3] + hex[4];
            b = "0x" + hex[5] + hex[6];
        }
        return "rgba(" + +r + "," + +g + "," + +b + "," + alpha + ")";
    }

    // Prepare Data from PHP
    const rawSales = '<?php echo json_encode($dailySales ?? [], JSON_HEX_APOS | JSON_HEX_QUOT); ?>';
    const rawDist = '<?php echo json_encode($salesByData ?? [], JSON_HEX_APOS | JSON_HEX_QUOT); ?>';
    const rawCheckin = '<?php echo json_encode($checkinStats ?? [], JSON_HEX_APOS | JSON_HEX_QUOT); ?>';

    const SALES_DATA = safeJson(rawSales) || [];
    const DIST_DATA = safeJson(rawDist) || [];
    const CHECKIN_DATA = safeJson(rawCheckin) || [];

    console.log('DASHBOARD DEBUG:', { SALES_DATA, DIST_DATA, CHECKIN_DATA });

    if (CHECKIN_DATA.length === 0) {
        console.warn('Checkin Data is Empty');
    }

    // Line Chart (Sales)
    if (document.getElementById('salesChart')) {
        const ctxSales = document.getElementById('salesChart').getContext('2d');

        // Gradient
        const gradient = ctxSales.createLinearGradient(0, 0, 0, 400);
        gradient.addColorStop(0, hexToRgba(BRAND_NEON, 0.5));
        gradient.addColorStop(1, hexToRgba(BRAND_NEON, 0.0));

        new Chart(ctxSales, {
            type: 'line',
            data: {
                labels: SALES_DATA.map(d => {
                    const date = new Date(d.date + 'T00:00:00');
                    return date.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit' });
                }),
                datasets: [{
                    label: 'Receita',
                    data: SALES_DATA.map(d => parseFloat(d.revenue || 0)),
                    borderColor: BRAND_NEON,
                    backgroundColor: gradient,
                    borderWidth: 3,
                    pointBackgroundColor: '#fff',
                    pointBorderColor: BRAND_NEON,
                    pointHoverBackgroundColor: BRAND_NEON,
                    pointHoverBorderColor: '#fff',
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                interaction: {
                    mode: 'index',
                    intersect: false,
                },
                plugins: {
                    legend: { display: false },
                    tooltip: {
                        callbacks: {
                            label: function (context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                if (context.parsed.y !== null) {
                                    label += new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(context.parsed.y);
                                }
                                return label;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        grid: { color: 'rgba(55, 65, 81, 0.3)' },
                        ticks: {
                            color: '#9CA3AF',
                            callback: function (value) {
                                return new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL', maximumSignificantDigits: 3 }).format(value);
                            }
                        }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { color: '#9CA3AF' }
                    }
                }
            }
        });
    }

    // Doughnut Chart (Distribution)
    if (document.getElementById('distributionChart')) {
        const ctxDist = document.getElementById('distributionChart').getContext('2d');
        new Chart(ctxDist, {
            type: 'doughnut',
            data: {
                labels: DIST_DATA.map(d => d.title || d.name || 'N/A'),
                datasets: [{
                    data: DIST_DATA.map(d => parseFloat(d.total_revenue || d.revenue || 0)),
                    backgroundColor: [BRAND_NEON, BRAND_SECONDARY, '#10B981', '#F59E0B', '#EF4444'],
                    hoverOffset: 4,
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                cutout: '70%',
                plugins: {
                    legend: { position: 'bottom', labels: { color: '#9CA3AF', padding: 20, usePointStyle: true } },
                    tooltip: {
                        callbacks: {
                            label: function (context) {
                                let label = context.label || '';
                                let value = context.parsed;
                                return label + ': ' + new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(value);
                            }
                        }
                    }
                }
            }
        });
    }

    // Check-in Bar Chart
    if (document.getElementById('checkinChart')) {
        const ctxCheckin = document.getElementById('checkinChart').getContext('2d');
        new Chart(ctxCheckin, {
            type: 'bar',
            data: {
                labels: CHECKIN_DATA.map(d => d.event_title || 'Evento'),
                datasets: [
                    {
                        label: 'Vendidos',
                        data: CHECKIN_DATA.map(d => parseInt(d.total_sold || 0)),
                        backgroundColor: 'rgba(112, 0, 255, 0.5)',
                        borderColor: BRAND_SECONDARY,
                        borderWidth: 1,
                        borderRadius: 4
                    },
                    {
                        label: 'Check-in',
                        data: CHECKIN_DATA.map(d => parseInt(d.total_checked_in || 0)),
                        backgroundColor: BRAND_NEON,
                        borderRadius: 4
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { labels: { color: '#9CA3AF' } }
                },
                scales: {
                    y: { grid: { color: 'rgba(55, 65, 81, 0.3)' }, ticks: { color: '#9CA3AF', stepSize: 1 } },
                    x: { grid: { display: false }, ticks: { color: '#9CA3AF' } }
                }
            }
        });
    }

    // Check-in Pie Chart (Overall) - Gauge Style
    if (document.getElementById('checkinPieChart')) {
        const totalSold = CHECKIN_DATA.reduce((acc, curr) => acc + parseInt(curr.total_sold || 0), 0);
        const totalChecked = CHECKIN_DATA.reduce((acc, curr) => acc + parseInt(curr.total_checked_in || 0), 0);
        const totalAbsent = Math.max(0, totalSold - totalChecked);
        const percentage = totalSold > 0 ? Math.round((totalChecked / totalSold) * 100) : 0;

        // Custom Plugin for Text in Center
        const centerTextPlugin = {
            id: 'centerText',
            beforeDraw: function (chart) {
                var width = chart.width, height = chart.height, ctx = chart.ctx;
                ctx.restore();
                var fontSize = (height / 114).toFixed(2);
                ctx.font = "bold " + fontSize + "em sans-serif";
                ctx.textBaseline = "middle";
                ctx.fillStyle = BRAND_NEON;
                var text = percentage + "%",
                    textX = Math.round((width - ctx.measureText(text).width) / 2),
                    textY = height / 2;
                ctx.fillText(text, textX, textY);
                ctx.save();
            }
        };

        const ctxCheckinPie = document.getElementById('checkinPieChart').getContext('2d');
        new Chart(ctxCheckinPie, {
            type: 'doughnut', // Better visuals than Pie
            data: {
                labels: ['Presente', 'Pendente'],
                datasets: [{
                    data: [totalChecked, totalAbsent],
                    backgroundColor: [BRAND_NEON, 'rgba(55, 65, 81, 0.3)'],
                    borderWidth: 0,
                    circumference: 360,
                    rotation: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                cutout: '80%',
                plugins: {
                    legend: { position: 'bottom', labels: { color: '#9CA3AF', usePointStyle: true } },
                    tooltip: { enabled: true }
                }
            },
            plugins: [centerTextPlugin]
        });
    }
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>