<?php
$title = 'Editar Ingresso - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto bg-gray-900 p-8 rounded-lg border border-gray-800">
  <h2 class="text-3xl font-bold mb-6 text-brand-neon">Editar Ingresso</h2>

  <form action="/admin/events/tickets/update" method="POST" class="space-y-4">
    <?php echo Helpers::csrf_field(); ?>
    <input type="hidden" name="id" value="<?php echo $data['ticket']['id']; ?>">

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <label class="block text-gray-400 mb-1">Nome do Ingresso</label>
        <input type="text" name="name" value="<?php echo htmlspecialchars($data['ticket']['name']); ?>" required
          class="w-full bg-black border border-gray-700 rounded p-3 text-white">
      </div>
      <div>
        <label class="block text-gray-400 mb-1">Nome do Lote</label>
        <input type="text" name="batch_name" value="<?php echo htmlspecialchars($data['ticket']['batch_name']); ?>"
          required class="w-full bg-black border border-gray-700 rounded p-3 text-white">
      </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
      <div>
        <label class="block text-gray-400 mb-1">Preço (R$)</label>
        <input type="number" name="price" step="0.01" value="<?php echo $data['ticket']['price']; ?>" required
          class="w-full bg-black border border-gray-700 rounded p-3 text-white">
      </div>
      <div>
        <label class="block text-gray-400 mb-1">Preço Promocional</label>
        <input type="number" name="promotional_price" step="0.01"
          value="<?php echo $data['ticket']['promotional_price']; ?>"
          class="w-full bg-black border border-gray-700 rounded p-3 text-white">
      </div>
      <div>
        <label class="block text-gray-400 mb-1">Quantidade Total</label>
        <input type="number" name="total_quantity" value="<?php echo $data['ticket']['total_quantity']; ?>" required
          class="w-full bg-black border border-gray-700 rounded p-3 text-white">
      </div>
    </div>

    <div class="bg-gray-800 p-4 rounded border border-gray-700">
      <h3 class="text-white font-bold mb-2">Período Promocional (Opcional)</h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-gray-400 mb-1">Início</label>
          <input type="datetime-local" name="promotion_start_date"
            value="<?php echo $data['ticket']['promotion_start_date'] ? date('Y-m-d\TH:i', strtotime($data['ticket']['promotion_start_date'])) : ''; ?>"
            class="w-full bg-black border border-gray-600 rounded p-3 text-white">
        </div>
        <div>
          <label class="block text-gray-400 mb-1">Fim</label>
          <input type="datetime-local" name="promotion_end_date"
            value="<?php echo $data['ticket']['promotion_end_date'] ? date('Y-m-d\TH:i', strtotime($data['ticket']['promotion_end_date'])) : ''; ?>"
            class="w-full bg-black border border-gray-600 rounded p-3 text-white">
        </div>
      </div>
    </div>

    <div>
      <label class="block text-gray-400 mb-1">Status</label>
      <select name="is_active" class="w-full bg-black border border-gray-700 rounded p-3 text-white">
        <option value="0" <?php echo $data['ticket']['is_active'] == 0 ? 'selected' : ''; ?>>Rascunho (Inativo)</option>
        <option value="1" <?php echo $data['ticket']['is_active'] == 1 ? 'selected' : ''; ?>>Publicado (Ativo)</option>
      </select>
    </div>

    <div class="flex justify-between items-center pt-4">
      <a href="/admin/events/tickets/delete?id=<?php echo $data['ticket']['id']; ?>"
        class="px-6 py-3 bg-red-600 text-white font-bold rounded hover:bg-red-700"
        onclick="return confirm('Tem certeza que deseja excluir este ingresso?');">
        EXCLUIR INGRESSO
      </a>

      <div class="flex space-x-4">
        <a href="/admin/events/tickets?id=<?php echo $data['ticket']['event_id']; ?>"
          class="px-6 py-3 text-gray-400 hover:text-white">Cancelar</a>
        <button type="submit" class="px-6 py-3 bg-brand-neon text-black font-bold rounded hover:bg-green-400">SALVAR
          ALTERAÇÕES</button>
      </div>
    </div>
  </form>
</div>


<?php require_once APP_PATH . '/views/partials/footer.php'; ?>

<script>
  const config = {
    enableTime: true,
    dateFormat: "Y-m-d H:i",
    time_24hr: true,
    locale: "pt",
    altInput: true,
    altFormat: "d/m/Y H:i",
    theme: "dark"
  };

  flatpickr("input[name='promotion_start_date']", config);
  flatpickr("input[name='promotion_end_date']", config);
</script>