<?php
$title = 'Operadores do Evento - Admin Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="mb-6 flex items-center gap-4">
  <a href="/admin/events" class="text-gray-500 hover:text-white transition"><i class="fas fa-arrow-left"></i> Voltar</a>
  <h2 class="text-3xl font-bold text-gray-800 dark:text-white">
    <span class="text-gray-500 text-xl font-normal">Operadores para:</span>
    <?php echo htmlspecialchars($event['title']); ?>
  </h2>
</div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-8">

  <!-- Left: Add New -->
  <div class="md:col-span-1">
    <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-xl p-6 shadow-lg">
      <h3 class="text-xl font-bold mb-4 text-gray-900 dark:text-white">Adicionar Operador</h3>
      <form action="/admin/events/operators/add" method="POST" class="space-y-4">
        <?php echo Helpers::csrf_field(); ?>
        <input type="hidden" name="event_id" value="<?php echo $event['id']; ?>">

        <div>
          <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Selecione o Operador</label>
          <select name="user_id" required
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 outline-none focus:border-brand-neon">
            <option value="">Selecione...</option>
            <?php foreach ($all_operators as $op): ?>
              <?php
              // Simple filter to hide already assigned (optional, but good UX)
              $isAssigned = false;
              foreach ($current_operators as $curr) {
                if ($curr['id'] == $op['id'])
                  $isAssigned = true;
              }
              if ($isAssigned)
                continue;
              ?>
              <option value="<?php echo $op['id']; ?>"><?php echo htmlspecialchars($op['name']); ?>
                (<?php echo $op['email']; ?>)</option>
            <?php endforeach; ?>
          </select>
        </div>

        <button type="submit"
          class="w-full bg-brand-neon text-black font-bold py-3 rounded hover:bg-cyan-400 transition flex items-center justify-center gap-2">
          <i class="fas fa-plus-circle"></i> Vincular Operador
        </button>

        <p class="text-xs text-gray-500 mt-2 text-center">
          Não encontrou? <a href="/admin/operators" class="text-brand-neon hover:underline">Cadastre um novo aqui</a>.
        </p>
      </form>
    </div>
  </div>

  <!-- Right: List -->
  <div class="md:col-span-2">
    <div
      class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-xl overflow-hidden shadow-lg">
      <div class="p-6 border-b border-gray-200 dark:border-gray-800 flex justify-between items-center">
        <h3 class="font-bold text-lg text-gray-900 dark:text-white">Operadores Vinculados</h3>
        <span
          class="text-sm bg-brand-neon/10 text-brand-neon px-2 py-1 rounded"><?php echo count($current_operators); ?>
          ativos</span>
      </div>

      <table class="w-full text-left border-collapse">
        <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
          <?php foreach ($current_operators as $op): ?>
            <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50 transition">
              <td class="p-4">
                <div class="font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($op['name']); ?></div>
                <div class="text-xs text-gray-500"><?php echo htmlspecialchars($op['email']); ?></div>
              </td>
              <td class="p-4 text-right">
                <a href="/admin/events/operators/remove?event_id=<?php echo $event['id']; ?>&user_id=<?php echo $op['id']; ?>"
                  class="text-red-500 hover:text-red-700 text-sm font-bold border border-red-500/20 px-3 py-1 rounded hover:bg-red-500/10 transition">
                  Remover Acesso
                </a>
              </td>
            </tr>
          <?php endforeach; ?>

          <?php if (empty($current_operators)): ?>
            <tr>
              <td colspan="2" class="p-8 text-center text-gray-500">
                Nenhum operador vinculado a este evento.
              </td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>