<?php
$title = 'Gerenciar Palestrantes - ' . htmlspecialchars($event['title']);
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto">
  <div class="flex justify-between items-center mb-6">
    <div>
      <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Palestrantes:
        <?php echo htmlspecialchars($event['title']); ?>
      </h2>
      <p class="text-gray-500 dark:text-gray-400">Adicione as estrelas do seu evento.</p>
    </div>
    <a href="/admin/events/edit?id=<?php echo $event['id']; ?>"
      class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Voltar para
      Evento</a>
  </div>

  <!-- Add Speaker Form -->
  <div
    class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 mb-8 shadow-sm dark:shadow-none">
    <h3 class="text-xl font-bold mb-4 text-gray-900 dark:text-white">Adicionar Novo Palestrante</h3>
    <form action="/admin/events/speakers/store" method="POST" class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <?php echo Helpers::csrf_field(); ?>
      <input type="hidden" name="event_id" value="<?php echo $event['id']; ?>">

      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Nome</label>
        <input type="text" name="name" required placeholder="Ex: Dr. Fulano"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Cargo / Título</label>
        <input type="text" name="role" placeholder="Ex: CEO da Tech"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>

      <div class="col-span-2">
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Foto (URL)</label>
        <input type="url" name="image_url" placeholder="https://..."
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>

      <div class="col-span-2">
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Bio Curta</label>
        <textarea name="bio" rows="2"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"></textarea>
      </div>

      <div class="col-span-2">
        <button type="submit"
          class="bg-brand-secondary dark:bg-brand-purple text-white font-bold py-2 px-6 rounded hover:scale-105 transition shadow-lg">ADICIONAR
          PALESTRANTE</button>
      </div>
    </form>
  </div>

  <!-- List Speakers -->
  <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <?php foreach ($speakers as $speaker): ?>
      <div
        class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 p-4 rounded flex items-center space-x-4 shadow-sm dark:shadow-none">
        <img src="<?php echo htmlspecialchars($speaker['image_url'] ?? 'https://placehold.co/100'); ?>" alt=""
          class="w-16 h-16 rounded-full object-cover border border-gray-300 dark:border-gray-700">
        <div class="flex-1">
          <h4 class="font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($speaker['name']); ?></h4>
          <p class="text-sm text-brand-secondary dark:text-brand-neon"><?php echo htmlspecialchars($speaker['role']); ?>
          </p>
          <p class="text-xs text-gray-500 mt-1 line-clamp-2"><?php echo htmlspecialchars($speaker['bio']); ?></p>
        </div>
        <a href="/admin/events/speakers/delete?id=<?php echo $speaker['id']; ?>&event_id=<?php echo $event['id']; ?>"
          class="text-red-500 hover:text-red-400 text-sm">X</a>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>