<?php
$title = 'Gerenciar Operadores - Admin Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="flex justify-between items-center mb-6">
  <h2 class="text-3xl font-bold text-gray-800 dark:text-white">Operadores de Check-in</h2>
  <button onclick="document.getElementById('createOperatorModal').classList.remove('hidden')"
    class="bg-brand-neon text-black font-bold py-2 px-4 rounded hover:bg-cyan-400 transition shadow-lg shadow-brand-neon/30">
    <i class="fas fa-plus mr-2"></i> Novo Operador
  </button>
</div>

<!-- Operators Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
  <?php foreach ($operators as $operator): ?>
    <div
      class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-xl p-6 hover:shadow-xl transition-all duration-300 relative group">

      <div class="flex items-center gap-4 mb-4">
        <div
          class="w-12 h-12 rounded-full bg-brand-secondary/10 flex items-center justify-center text-brand-secondary dark:text-brand-neon">
          <i class="fas fa-id-badge text-2xl"></i>
        </div>
        <div>
          <h3 class="font-bold text-lg text-gray-900 dark:text-white"><?php echo htmlspecialchars($operator['name']); ?>
          </h3>
          <p class="text-sm text-gray-500"><?php echo htmlspecialchars($operator['email']); ?></p>
        </div>
      </div>

      <div
        class="flex items-center justify-between text-sm text-gray-500 dark:text-gray-400 mt-4 pt-4 border-t border-gray-100 dark:border-gray-800">
        <span><i class="fas fa-phone mr-1"></i> <?php echo htmlspecialchars($operator['phone'] ?? 'N/A'); ?></span>

        <div class="flex gap-2">
          <button onclick='openEditModal(<?php echo json_encode($operator); ?>)'
            class="text-blue-500 hover:text-blue-700 p-1">
            <i class="fas fa-edit"></i>
          </button>
          <!-- Reuse Delete Logic -->
          <a href="/admin/operators/delete?id=<?php echo $operator['id']; ?>"
            onclick="return confirm('Tem certeza? Isso removerá o acesso deste operador.')"
            class="text-red-500 hover:text-red-700 p-1">
            <i class="fas fa-trash"></i>
          </a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>

  <?php if (empty($operators)): ?>
    <div class="col-span-full text-center py-12 text-gray-500">
      <i class="fas fa-users-slash text-4xl mb-3 opacity-50"></i>
      <p>Nenhum operador cadastrado.</p>
    </div>
  <?php endif; ?>
</div>

<!-- Create Modal -->
<div id="createOperatorModal" class="fixed inset-0 z-50 hidden overflow-y-auto" aria-labelledby="modal-title"
  role="dialog" aria-modal="true">
  <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
    <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"
      onclick="document.getElementById('createOperatorModal').classList.add('hidden')"></div>
    <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
    <div
      class="inline-block align-bottom bg-white dark:bg-gray-900 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
      <form action="/admin/operators/store" method="POST" class="p-6 bg-white dark:bg-gray-900">
        <?php echo Helpers::csrf_field(); ?>

        <div class="flex justify-between items-center mb-6">
          <h3 class="text-xl font-bold text-brand-secondary dark:text-brand-neon" id="modal-title">Novo Operador</h3>
          <button type="button" onclick="document.getElementById('createOperatorModal').classList.add('hidden')"
            class="text-gray-400 hover:text-white">
            <i class="fas fa-times"></i>
          </button>
        </div>

        <div class="space-y-4">
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Nome Completo</label>
            <input type="text" name="name" required
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Email</label>
            <input type="email" name="email" required
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Telefone / WhatsApp</label>
            <input type="text" name="phone"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Senha Acesso</label>
            <input type="password" name="password" required minlength="6"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
        </div>

        <div class="mt-8 flex justify-end gap-3 border-t border-gray-200 dark:border-gray-800 pt-4">
          <button type="button" onclick="document.getElementById('createOperatorModal').classList.add('hidden')"
            class="px-4 py-2 rounded text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-800 transition">Cancelar</button>
          <button type="submit"
            class="bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold px-6 py-2 rounded hover:brightness-110 transition shadow-lg shadow-brand-neon/20">
            Criar Operador
          </button>
        </div>
      </form>
      </form>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div id="editOperatorModal" class="fixed inset-0 z-50 hidden overflow-y-auto" aria-labelledby="modal-title"
  role="dialog" aria-modal="true">
  <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
    <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"
      onclick="closeEditModal()"></div>
    <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
    <div
      class="inline-block align-bottom bg-white dark:bg-gray-900 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
      <form action="/admin/operators/update" method="POST" class="p-6 bg-white dark:bg-gray-900">
        <?php echo Helpers::csrf_field(); ?>
        <input type="hidden" name="id" id="edit_id">

        <div class="flex justify-between items-center mb-6">
          <h3 class="text-xl font-bold text-brand-secondary dark:text-brand-neon">Editar Operador</h3>
          <button type="button" onclick="closeEditModal()" class="text-gray-400 hover:text-white">
            <i class="fas fa-times"></i>
          </button>
        </div>

        <div class="space-y-4">
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Nome Completo</label>
            <input type="text" name="name" id="edit_name" required
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Email</label>
            <input type="email" name="email" id="edit_email" required
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Telefone / WhatsApp</label>
            <input type="text" name="phone" id="edit_phone"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Nova Senha (deixe em branco para manter)</label>
            <input type="password" name="password" minlength="6" placeholder="******"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
        </div>

        <div class="mt-8 flex justify-end gap-3 border-t border-gray-200 dark:border-gray-800 pt-4">
          <button type="button" onclick="closeEditModal()"
            class="px-4 py-2 rounded text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-800 transition">Cancelar</button>
          <button type="submit"
            class="bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold px-6 py-2 rounded hover:brightness-110 transition shadow-lg shadow-brand-neon/20">
            Salvar Alterações
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  function openEditModal(operator) {
    document.getElementById('edit_id').value = operator.id;
    document.getElementById('edit_name').value = operator.name;
    document.getElementById('edit_email').value = operator.email;
    document.getElementById('edit_phone').value = operator.phone || '';
    document.getElementById('editOperatorModal').classList.remove('hidden');
  }

  function closeEditModal() {
    document.getElementById('editOperatorModal').classList.add('hidden');
  }
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>