<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Relatório - Cê Vai</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    @media print {
      body {
        -webkit-print-color-adjust: exact;
      }
    }
  </style>
</head>

<body class="bg-white text-black p-8" onload="window.print()">

  <div class="mb-8 border-b pb-4">
    <h1 class="text-2xl font-bold uppercase mb-2">Relatório de
      <?php echo $data['type'] === 'sales' ? 'Vendas' : 'Participantes'; ?></h1>
    <p class="text-sm text-gray-600">Gerado em: <?php echo date('d/m/Y H:i'); ?></p>
    <?php if (!empty($data['eventName'])): ?>
      <p class="text-sm text-gray-600">Evento: <strong><?php echo htmlspecialchars($data['eventName']); ?></strong></p>
    <?php endif; ?>
  </div>

  <table class="w-full text-left text-sm border-collapse">
    <thead>
      <tr class="border-b-2 border-black">
        <?php if ($data['type'] == 'sales'): ?>
          <?php if (!empty($data['filters']['event_id'])): ?>
            <th class="py-2">Tipo de Ingresso</th>
            <th class="py-2 text-right">Qtd</th>
            <th class="py-2 text-right">Receita</th>
          <?php else: ?>
            <th class="py-2">Evento</th>
            <th class="py-2 text-right">Pedidos</th>
            <th class="py-2 text-right">Receita</th>
          <?php endif; ?>
        <?php else: ?>
          <th class="py-2">Nome</th>
          <th class="py-2">Email</th>
          <th class="py-2">Ingresso</th>
          <th class="py-2">Código</th>
          <th class="py-2">Status</th>
        <?php endif; ?>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($data['reportData'] as $row): ?>
        <tr class="border-b border-gray-300">
          <?php if ($data['type'] == 'sales'): ?>
            <?php if (!empty($data['filters']['event_id'])): ?>
              <td class="py-2"><?php echo htmlspecialchars($row['name']); ?></td>
              <td class="py-2 text-right"><?php echo $row['count']; ?></td>
              <td class="py-2 text-right">R$ <?php echo number_format($row['revenue'] ?? 0, 2, ',', '.'); ?></td>
            <?php else: ?>
              <td class="py-2"><?php echo htmlspecialchars($row['title']); ?></td>
              <td class="py-2 text-right"><?php echo $row['total_orders']; ?></td>
              <td class="py-2 text-right">R$ <?php echo number_format($row['total_revenue'] ?? 0, 2, ',', '.'); ?></td>
            <?php endif; ?>
          <?php else: ?>
            <td class="py-2"><?php echo htmlspecialchars($row['user_name']); ?></td>
            <td class="py-2"><?php echo htmlspecialchars($row['user_email']); ?></td>
            <td class="py-2"><?php echo htmlspecialchars($row['ticket_name']); ?></td>
            <td class="py-2 font-mono text-xs"><?php echo $row['unique_code']; ?></td>
            <td class="py-2 uppercase text-xs"><?php echo $row['status'] == 'active' ? 'Ativo' : 'Utilizado'; ?></td>
          <?php endif; ?>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

</body>

</html>