<?php
$title = 'Configurações - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-4xl mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
  <h2 class="text-3xl font-bold mb-6 text-brand-secondary dark:text-brand-neon">Configurações do Sistema</h2>

  <?php if (isset($_GET['msg']) && $_GET['msg'] == 'configuracoes_salvas'): ?>
    <div class="bg-green-500/20 text-green-400 p-4 rounded mb-6 border border-green-500/30">
      Configurações salvas com sucesso!
    </div>
  <?php endif; ?>

  <form action="/admin/settings/update" method="POST" enctype="multipart/form-data" class="space-y-8">
    <?php echo Helpers::csrf_field(); ?>
    <!-- General -->
    <div>
      <h3
        class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
        Geral</h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1">Nome do Site</label>
          <input type="text" name="site_name"
            value="<?php echo htmlspecialchars($data['settings']['site_name'] ?? APP_NAME); ?>"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1">Email de Contato</label>
          <input type="email" name="contact_email"
            value="<?php echo htmlspecialchars($data['settings']['contact_email'] ?? 'contato@cevai.com'); ?>"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1">WhatsApp de Suporte</label>
          <input type="text" name="contact_whatsapp"
            value="<?php echo htmlspecialchars($data['settings']['contact_whatsapp'] ?? ''); ?>"
            placeholder="5511999999999"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <div class="md:col-span-2">
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Logo para Fundo Escuro (Padrão)</label>
            <div class="flex items-center gap-4">
              <?php if (!empty($data['settings']['site_logo'])): ?>
                <img src="<?php echo htmlspecialchars($data['settings']['site_logo']); ?>" alt="Logo Dark"
                  class="h-12 bg-gray-900 border border-gray-700 rounded p-1 object-contain">
              <?php endif; ?>
              <input type="file" name="site_logo" accept="image/*"
                class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
            </div>
            <p class="text-xs text-gray-500 mt-1">Exibida no modo escuro. Recomendado: Branco/Neon.</p>
          </div>

          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Logo para Fundo Claro</label>
            <div class="flex items-center gap-4">
              <?php if (!empty($data['settings']['site_logo_inverted'])): ?>
                <img src="<?php echo htmlspecialchars($data['settings']['site_logo_inverted']); ?>" alt="Logo Light"
                  class="h-12 bg-white border border-gray-200 rounded p-1 object-contain">
              <?php endif; ?>
              <input type="file" name="site_logo_inverted" accept="image/*"
                class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
            </div>
            <p class="text-xs text-gray-500 mt-1">Exibida no modo claro. Recomendado: Preto/Escuro.</p>
          </div>

          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Favicon (Ícone da Aba)</label>
            <div class="flex items-center gap-4">
              <?php if (!empty($data['settings']['site_favicon'])): ?>
                <img src="<?php echo htmlspecialchars($data['settings']['site_favicon']); ?>" alt="Favicon Atual"
                  class="h-8 w-8 bg-white dark:bg-gray-800 rounded p-1 object-contain">
              <?php endif; ?>
              <input type="file" name="site_favicon" accept="image/*"
                class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
            </div>
            <p class="text-xs text-gray-500 mt-1">Recomendado: ICO, PNG ou SVG quadrado (32x32).</p>
          </div>

          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Logo para E-mails (Cabeçalho)</label>
            <div class="flex items-center gap-4">
              <?php if (!empty($data['settings']['email_logo'])): ?>
                <img src="<?php echo htmlspecialchars($data['settings']['email_logo']); ?>" alt="Logo Email"
                  class="h-12 bg-gray-900 border border-gray-700 rounded p-1 object-contain">
              <?php endif; ?>
              <input type="file" name="email_logo" accept="image/*"
                class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
            </div>
            <p class="text-xs text-gray-500 mt-1">Exibida no topo dos emails enviados. Recomendado: PNG Transparente.
            </p>
          </div>
        </div>
      </div>

      <!-- Asaas Payment -->
      <div>
        <h3
          class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
          Pagamento (Asaas)</h3>
        <div class="space-y-4">
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">API Key</label>
            <input type="password" name="asaas_api_key"
              value="<?php echo htmlspecialchars($data['settings']['asaas_api_key'] ?? ''); ?>"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">URL da API</label>
            <select name="asaas_url"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
              <option value="https://sandbox.asaas.com/api/v3" <?php echo ($data['settings']['asaas_url'] ?? '') == 'https://sandbox.asaas.com/api/v3' ? 'selected' : ''; ?>>Sandbox (Teste)</option>
              <option value="https://api.asaas.com/api/v3" <?php echo ($data['settings']['asaas_url'] ?? '') == 'https://api.asaas.com/api/v3' ? 'selected' : ''; ?>>Produção</option>
            </select>
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Webhook Token (Assinatura)</label>
            <input type="password" name="asaas_webhook_token"
              value="<?php echo htmlspecialchars($data['settings']['asaas_webhook_token'] ?? ''); ?>"
              placeholder="Token definido no painel do Asaas"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">URL do Webhook (Para configurar no Asaas)</label>
            <div class="flex">
              <input type="text" readonly value="<?php echo APP_URL . '/api/webhook/asaas'; ?>"
                class="w-full bg-gray-100 dark:bg-gray-800 border border-gray-300 dark:border-gray-700 rounded-l p-3 text-gray-500 dark:text-gray-400 outline-none cursor-not-allowed font-mono text-sm">
              <button type="button"
                onclick="navigator.clipboard.writeText('<?php echo APP_URL . '/api/webhook/asaas'; ?>'); this.innerText = 'COPIADO!';"
                class="bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold px-4 rounded-r hover:brightness-110 transition border border-l-0 border-brand-secondary dark:border-brand-neon text-xs">
                COPIAR
              </button>
            </div>
          </div>
        </div>
      </div>

      <!-- SMTP Email -->
      <div>
        <h3
          class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
          Servidor de Email (SMTP)</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Host SMTP</label>
            <input type="text" name="smtp_host"
              value="<?php echo htmlspecialchars($data['settings']['smtp_host'] ?? ''); ?>"
              placeholder="smtp.mailtrap.io"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Porta</label>
            <input type="text" name="smtp_port"
              value="<?php echo htmlspecialchars($data['settings']['smtp_port'] ?? '2525'); ?>"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Usuário</label>
            <input type="text" name="smtp_user"
              value="<?php echo htmlspecialchars($data['settings']['smtp_user'] ?? ''); ?>"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Senha</label>
            <input type="password" name="smtp_pass"
              value="<?php echo htmlspecialchars($data['settings']['smtp_pass'] ?? ''); ?>"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
        </div>
      </div>


      <!-- Test Email Section (Outside Main Form) -->


      <!-- Styling -->
      <div>
        <h3
          class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
          Aparência</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Cor Primária (Neon)</label>
            <div class="flex">
              <input type="color" name="color_brand_neon"
                value="<?php echo htmlspecialchars($data['settings']['color_brand_neon'] ?? '#00F3FF'); ?>"
                class="h-12 w-12 bg-transparent border-0 cursor-pointer p-0">
              <input type="text" name="color_brand_neon_text"
                value="<?php echo htmlspecialchars($data['settings']['color_brand_neon'] ?? '#00F3FF'); ?>"
                class="flex-1 bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-r p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none ml-2"
                onchange="this.previousElementSibling.value = this.value">
            </div>
          </div>
          <div>
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Cor Secundária</label>
            <div class="flex">
              <input type="color" name="color_brand_secondary"
                value="<?php echo htmlspecialchars($data['settings']['color_brand_secondary'] ?? '#7000FF'); ?>"
                class="h-12 w-12 bg-transparent border-0 cursor-pointer p-0">
              <input type="text" name="color_brand_secondary_text"
                value="<?php echo htmlspecialchars($data['settings']['color_brand_secondary'] ?? '#7000FF'); ?>"
                class="flex-1 bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-r p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none ml-2"
                onchange="this.previousElementSibling.value = this.value">
            </div>
          </div>
        </div>
      </div>

      <!-- SEO -->
      <div>
        <h3
          class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
          SEO (Otimização para Buscas)</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Sufixo do Título da Página</label>
            <input type="text" name="seo_title_suffix"
              value="<?php echo htmlspecialchars($data['settings']['seo_title_suffix'] ?? '| Cê Vai'); ?>"
              placeholder="| Nome do Site"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
            <p class="text-xs text-gray-500 mt-1">Ex: Título do Evento <strong>| Cê Vai</strong></p>
          </div>
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Descrição Padrão do Site</label>
            <textarea name="seo_description_default"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none h-20"><?php echo htmlspecialchars($data['settings']['seo_description_default'] ?? ''); ?></textarea>
            <p class="text-xs text-gray-500 mt-1">Usada quando a página não tem uma descrição específica.</p>
          </div>
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Palavras-chave (Keywords)</label>
            <textarea name="seo_keywords_default"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none h-20"><?php echo htmlspecialchars($data['settings']['seo_keywords_default'] ?? ''); ?></textarea>
            <p class="text-xs text-gray-500 mt-1">Separadas por vírgula.</p>
          </div>
        </div>
      </div>

      <!-- Agenda Page Settings -->
      <div>
        <h3
          class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
          Página "Outros Eventos" (Agenda)
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Título do Hero</label>
            <input type="text" name="agenda_hero_title"
              value="<?php echo htmlspecialchars($data['settings']['agenda_hero_title'] ?? 'Próximos Eventos'); ?>"
              placeholder="Ex: Próximos Eventos"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Subtítulo do Hero</label>
            <input type="text" name="agenda_hero_subtitle"
              value="<?php echo htmlspecialchars($data['settings']['agenda_hero_subtitle'] ?? 'Confira nossa agenda completa.'); ?>"
              placeholder="Ex: Confira nossa agenda completa."
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Título SEO (Browser Tab)</label>
            <input type="text" name="agenda_seo_title"
              value="<?php echo htmlspecialchars($data['settings']['agenda_seo_title'] ?? 'Agenda de Eventos - Cê Vai'); ?>"
              placeholder="Ex: Agenda de Eventos - Cê Vai"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          </div>
          <div class="md:col-span-2">
            <label class="block text-gray-700 dark:text-gray-400 mb-1">Descrição SEO</label>
            <textarea name="agenda_seo_description"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none h-20"><?php echo htmlspecialchars($data['settings']['agenda_seo_description'] ?? ''); ?></textarea>
          </div>
        </div>
      </div>

      <!-- Maintenance -->
      <div>
        <h3
          class="text-xl font-bold mb-4 text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-2">
          Segurança e Acesso</h3>
        <div class="space-y-4">
          <label class="flex items-center space-x-2">
            <input type="checkbox" name="maintenance_mode" value="1" <?php echo ($data['settings']['maintenance_mode'] ?? '0') == '1' ? 'checked' : ''; ?>
              class="form-checkbox h-5 w-5 text-brand-secondary dark:text-brand-neon rounded bg-gray-50 dark:bg-black border-gray-300 dark:border-gray-700 focus:ring-brand-secondary dark:focus:ring-brand-neon">
            <span class="text-gray-700 dark:text-gray-300">Ativar Modo Manutenção (Site inacessível para
              usuários)</span>
          </label>

          <label class="flex items-center space-x-2">
            <input type="checkbox" name="email_verification_enabled" value="1" <?php echo ($data['settings']['email_verification_enabled'] ?? '0') == '1' ? 'checked' : ''; ?>
              class="form-checkbox h-5 w-5 text-brand-secondary dark:text-brand-neon rounded bg-gray-50 dark:bg-black border-gray-300 dark:border-gray-700 focus:ring-brand-secondary dark:focus:ring-brand-neon">
            <span class="text-gray-700 dark:text-gray-300">Exigir verificação de e-mail no cadastro</span>
          </label>
        </div>
      </div>

      <div class="pt-4 border-t border-gray-200 dark:border-gray-800">
        <button type="submit"
          class="bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold px-8 py-3 rounded hover:brightness-110 transition w-full md:w-auto">
          SALVAR CONFIGURAÇÕES
        </button>
      </div>
  </form>

  <!-- Test Email Section (Moved to bottom) -->
  <div
    class="mt-16 bg-white dark:bg-gray-800 p-6 rounded border border-gray-200 dark:border-gray-700 shadow-sm dark:shadow-none">
    <h4 class="font-bold text-gray-900 dark:text-white mb-4">Testar Configuração de Email</h4>
    <form action="/admin/settings/test-email" method="POST" class="flex gap-4">
      <input type="email" name="test_email" placeholder="Seu email para teste" required
        class="flex-1 bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      <button type="submit" class="bg-gray-600 hover:bg-gray-500 text-white font-bold px-6 py-3 rounded transition">
        Enviar Teste
      </button>
    </form>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>