<?php
$title = 'Login - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-md mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg shadow-lg dark:shadow-brand-secondary/20 border border-gray-200 dark:border-gray-800 transition-colors duration-300">
  <h2 class="text-3xl font-bold mb-6 text-center text-gray-900 dark:text-white dark:neon-text">Login</h2>

  <?php if (isset($error)): ?>
    <div
      class="bg-red-100 dark:bg-red-500/20 border border-red-500 text-red-600 dark:text-red-100 p-3 rounded mb-4 text-sm text-center">
      <?php echo $error; ?>
    </div>
  <?php endif; ?>

  <form action="/login" method="POST" class="space-y-4">
    <?php echo Helpers::csrf_field(); ?>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">E-mail</label>
      <input type="email" name="email" required value="<?php echo htmlspecialchars($data['email'] ?? ''); ?>"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-neon focus:outline-none focus:shadow-brand-neon/30 text-gray-900 dark:text-white transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Senha</label>
      <input type="password" name="password" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-neon focus:outline-none focus:shadow-brand-neon/30 text-gray-900 dark:text-white transition-colors">
    </div>
    <div class="text-right">
      <a href="/forgot-password"
        class="text-xs text-brand-secondary dark:text-brand-neon hover:text-brand-neon dark:hover:text-white transition">Esqueci
        minha
        senha</a>
    </div>
    <button type="submit"
      class="w-full py-3 rounded-xl font-bold uppercase tracking-wider shadow-lg bg-brand-neon text-black hover:bg-brand-secondary hover:text-white transition-all duration-300 transform hover:-translate-y-1 hover:shadow-brand-neon/40 mt-4">ENTRAR</button>
  </form>

  <div class="mt-4 text-center text-sm text-gray-600 dark:text-gray-500">
    Não tem conta? <a href="/register"
      class="text-brand-secondary dark:text-brand-neon hover:text-gray-900 dark:hover:text-white font-bold">Cadastre-se</a>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>