<?php
$title = 'Criar Conta - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-md mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg shadow-lg dark:shadow-brand-neon/20 border border-gray-200 dark:border-gray-800 transition-colors duration-300">
  <h2 class="text-3xl font-bold mb-6 text-center text-brand-secondary dark:text-brand-neon">Criar Conta</h2>

  <?php if (isset($error)): ?>
    <div
      class="bg-red-100 dark:bg-red-500/20 border border-red-500 text-red-600 dark:text-red-100 p-3 rounded mb-4 text-sm text-center">
      <?php echo $error; ?>
    </div>
  <?php endif; ?>

  <form action="/register" method="POST" class="space-y-4">
    <?php echo Helpers::csrf_field(); ?>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Nome Completo</label>
      <input type="text" name="name" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon focus:outline-none text-gray-900 dark:text-white transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">CPF</label>
      <input type="text" name="cpf" required placeholder="000.000.000-00"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon focus:outline-none text-gray-900 dark:text-white transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Telefone (WhatsApp)</label>
      <input type="text" name="phone" required placeholder="(00) 00000-0000"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon focus:outline-none text-gray-900 dark:text-white transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">E-mail</label>
      <input type="email" name="email" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon focus:outline-none text-gray-900 dark:text-white transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Senha</label>
      <input type="password" name="password" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon focus:outline-none text-gray-900 dark:text-white transition-colors">
    </div>

    <!-- Terms Checkbox -->
    <div class="flex items-start mt-4">
      <div class="flex items-center h-5">
        <input id="terms" name="terms" type="checkbox" required
          class="w-4 h-4 rounded bg-gray-200 dark:bg-gray-800 border-gray-300 dark:border-gray-600 text-brand-neon focus:ring-brand-neon focus:ring-offset-white dark:focus:ring-offset-gray-900">
      </div>
      <div class="ml-3 text-sm">
        <label for="terms" class="text-gray-600 dark:text-gray-400">
          Li e concordo com os <a href="/terms" target="_blank"
            class="text-brand-secondary dark:text-brand-neon hover:underline">Termos de
            Uso</a> e <a href="/privacy" target="_blank"
            class="text-brand-secondary dark:text-brand-neon hover:underline">Aviso de
            Privacidade</a>.
        </label>
      </div>
    </div>

    <button type="submit"
      class="w-full py-3 rounded-xl font-bold uppercase tracking-wider shadow-lg bg-brand-neon text-black hover:bg-brand-secondary hover:text-white transition-all duration-300 transform hover:-translate-y-1 hover:shadow-brand-neon/40 mt-6 disabled:opacity-50 disabled:cursor-not-allowed">CADASTRAR</button>
  </form>

  <div class="mt-4 text-center text-sm text-gray-600 dark:text-gray-500">
    Já tem conta? <a href="/login"
      class="text-brand-secondary dark:text-brand-neon hover:text-black dark:hover:text-white">Faça login</a>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>