<?php
$title = 'Checkout - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-2xl mx-auto py-6 md:py-12 px-2 md:px-4">
  <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-lg p-4 md:p-8 shadow-xl">
    <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-6">Resumo do Pedido</h2>

    <div class="flex items-start space-x-4 mb-6 pb-6 border-b border-gray-200 dark:border-gray-800">
      <img src="<?php echo htmlspecialchars($event['image_cover']); ?>" class="w-24 h-24 object-cover rounded"
        alt="Event">
      <div>
        <h3 class="text-xl font-bold text-brand-secondary dark:text-brand-neon">
          <?php echo htmlspecialchars($event['title']); ?>
        </h3>
        <p class="text-gray-500 dark:text-gray-400 text-sm mb-1">
          <?php echo date('d/m/Y H:i', strtotime($event['start_date'])); ?>
        </p>
        <p class="text-gray-500 dark:text-gray-400 text-sm"><?php echo htmlspecialchars($event['location']); ?></p>
      </div>
    </div>

    <div class="flex justify-between items-center mb-6 text-lg">
      <div>
        <span
          class="block text-gray-900 dark:text-white font-bold"><?php echo htmlspecialchars($ticket['name']); ?></span>
        <span
          class="text-xs text-brand-secondary dark:text-brand-purple bg-brand-secondary/10 dark:bg-brand-purple/10 px-2 py-1 rounded"><?php echo htmlspecialchars($ticket['batch_name']); ?></span>
      </div>
      <div class="text-right">
        <?php if ($price == 0): ?>
          <span class="text-brand-secondary dark:text-brand-neon font-bold">GRATUITO</span>
        <?php else: ?>
          <span class="text-gray-900 dark:text-white font-bold">R$
            <?php echo number_format($price, 2, ',', '.'); ?></span>
        <?php endif; ?>
      </div>
    </div>

    <?php if ($price > 0): ?>
      <form action="/checkout/process" method="POST" class="space-y-4">
        <?php echo Helpers::csrf_field(); ?>
        <input type="hidden" name="ticket_id" value="<?php echo $ticket['id']; ?>">

        <div>
          <label class="block text-gray-500 dark:text-gray-400 mb-2">Forma de Pagamento</label>
          <div class="grid grid-cols-2 gap-4 mb-6">
            <label class="cursor-pointer">
              <input type="radio" name="payment_method" value="pix" class="peer hidden" checked
                onchange="togglePaymentGroups()">
              <div
                class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 p-4 rounded text-center peer-checked:border-brand-secondary dark:peer-checked:border-brand-neon hover:border-gray-400 dark:hover:border-gray-500 transition text-gray-900 dark:text-white">
                <span class="block font-bold">PIX</span>
                <span class="text-xs text-gray-500">Aprovação Imediata</span>
              </div>
            </label>
            <label class="cursor-pointer">
              <input type="radio" name="payment_method" value="credit_card" class="peer hidden"
                onchange="togglePaymentGroups()">
              <div
                class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 p-4 rounded text-center peer-checked:border-brand-secondary dark:peer-checked:border-brand-neon hover:border-gray-400 dark:hover:border-gray-500 transition text-gray-900 dark:text-white">
                <span class="block font-bold">Cartão</span>
                <span class="text-xs text-gray-500">Até 12x</span>
              </div>
            </label>
          </div>

          <!-- Credit Card Form -->
          <div id="credit-card-group"
            class="hidden space-y-4 bg-gray-50 dark:bg-gray-800 p-4 rounded border border-gray-200 dark:border-gray-700">
            <div>
              <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Nome no Cartão</label>
              <input type="text" name="card_holder_name"
                class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                placeholder="Como impresso no cartão">
            </div>
            <div>
              <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Número do Cartão</label>
              <input type="text" name="card_number"
                class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                placeholder="0000 0000 0000 0000">
            </div>
            <div class="grid grid-cols-3 gap-4">
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Mês</label>
                <input type="text" name="card_expiry_month"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="MM" maxlength="2">
              </div>
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Ano</label>
                <input type="text" name="card_expiry_year"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="AAAA" maxlength="4">
              </div>
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">CCV</label>
                <input type="text" name="card_ccv"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="123" maxlength="4">
              </div>
            </div>

            <!-- Holder Info -->
            <div class="grid grid-cols-2 gap-4">
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">CPF/CNPJ do Titular</label>
                <input type="text" name="card_holder_cpf"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="000.000.000-00">
              </div>
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Telefone do Titular</label>
                <input type="text" name="card_holder_phone"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="(00) 00000-0000">
              </div>
            </div>

            <div class="grid grid-cols-2 gap-4">
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">CEP</label>
                <input type="text" name="card_holder_postal_code"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="00000-000">
              </div>
              <div>
                <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Número Endereço</label>
                <input type="text" name="card_holder_address_number"
                  class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"
                  placeholder="123">
              </div>
            </div>

            <div>
              <label class="block text-gray-500 dark:text-gray-400 text-sm mb-1">Parcelamento</label>
              <select name="installment_count"
                class="w-full bg-white dark:bg-black border border-gray-300 dark:border-gray-600 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none appearance-none">
                <?php
                $maxInstallments = 3;
                for ($i = 1; $i <= $maxInstallments; $i++):
                  $installmentValue = $price / $i;
                  ?>
                  <option value="<?php echo $i; ?>"><?php echo $i; ?>x de R$
                    <?php echo number_format($installmentValue, 2, ',', '.'); ?> sem juros
                  </option>
                <?php endfor; ?>
              </select>
            </div>
          </div>

          <button type="submit"
            class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-4 rounded-lg shadow-lg transition transform hover:-translate-y-1 mt-6">
            Confirmar Pagamento <i class="fas fa-check-circle ml-2"></i>
          </button>
      </form>
    <?php else: ?>
      <!-- Free Ticket Confirmation -->
      <div class="text-center py-8">
        <div class="mb-6">
          <i class="fas fa-check-circle text-6xl text-brand-secondary dark:text-brand-neon mb-4"></i>
          <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Ingresso Gratuito</h3>
          <p class="text-gray-500 dark:text-gray-400">Clique abaixo para garantir seu ingresso agora.</p>
        </div>

        <form action="/checkout/process" method="POST">
          <?php echo Helpers::csrf_field(); ?>
          <input type="hidden" name="ticket_id" value="<?php echo $ticket['id']; ?>">
          <!-- Payment Method irrelevant for free, but good to set default or use logic controller side -->
          <input type="hidden" name="payment_method" value="free">

          <button type="submit"
            class="w-full bg-brand-secondary hover:bg-brand-secondary/80 text-white font-bold py-4 rounded-lg shadow-lg transition transform hover:-translate-y-1">
            Garantir Ingresso Grátis <i class="fas fa-ticket-alt ml-2"></i>
          </button>
        </form>
      </div>
    <?php endif; ?>

    <script>
      function togglePaymentGroups() {
        const method = document.querySelector('input[name="payment_method"]:checked').value;
        const ccGroup = document.getElementById('credit-card-group');
        if (method === 'credit_card') {
          ccGroup.classList.remove('hidden');
        } else {
          ccGroup.classList.add('hidden');
        }
      }

      // Disable button on submit to prevent double clicks
      document.querySelectorAll('form').forEach(form => {
        form.addEventListener('submit', function () {
          const btn = this.querySelector('button[type="submit"]');
          if (btn) {
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processando...';
            btn.classList.add('opacity-75', 'cursor-not-allowed');
          }
        });
      });
    </script>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>