<?php
$title = 'Pagamento Pix - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-2xl mx-auto py-12">
  <div class="bg-gray-900 border border-gray-800 rounded-lg p-8 text-center">
    <h2 class="text-3xl font-bold text-white mb-2">Finalize seu Pagamento</h2>
    <p class="text-gray-400 mb-8">Escaneie o QR Code abaixo para pagar via Pix</p>

    <div class="bg-white p-4 inline-block rounded-lg mb-6">
      <!-- Assuming QR Code String is sufficient for some generator OR Base64 image -->
      <?php if (!empty($qr_image)): ?>
        <img src="data:image/png;base64,<?php echo $qr_image; ?>" class="w-64 h-64">
      <?php elseif (!empty($qr_code)): ?>
        <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=<?php echo urlencode($qr_code); ?>"
          class="w-64 h-64">
      <?php endif; ?>
    </div>

    <div class="bg-black border border-gray-700 p-4 rounded mb-8 relative group cursor-pointer" onclick="copyPix()">
      <p class="text-xs text-brand-neon uppercase font-bold mb-2">Pix Copia e Cola</p>
      <p class="text-gray-400 font-mono text-sm break-all" id="pixCode"><?php echo htmlspecialchars($qr_code); ?></p>
      <div
        class="absolute inset-0 bg-brand-neon/10 flex items-center justify-center opacity-0 group-hover:opacity-100 transition">
        <span class="font-bold text-white">Clique para Copiar</span>
      </div>
    </div>

    <script>
      function copyPix() {
        const code = document.getElementById('pixCode').innerText;
        navigator.clipboard.writeText(code);
        alert('Código Pix copiado!');
      }
    </script>

    <div class="flex justify-center space-x-4">
      <a href="/client/dashboard"
        class="bg-gray-800 hover:bg-gray-700 text-white font-bold py-3 px-8 rounded transition">
        Já paguei
      </a>
    </div>

    <p class="text-xs text-gray-500 mt-4">A liberação do ingresso ocorre automaticamente após o pagamento.</p>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>