<?php
$title = 'Ingresso #' . htmlspecialchars($ticket['unique_code']);
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-2xl mx-auto py-12">
  <!-- Back Button -->
  <div class="mb-6 no-print">
    <a href="/client/dashboard" class="text-gray-400 hover:text-white flex items-center transition">
      <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
      </svg>
      Voltar ao Dashboard
    </a>
  </div>

  <!-- Ticket Card -->
  <div id="ticket-print-area"
    class="bg-white text-black rounded-3xl overflow-hidden shadow-[0_0_50px_rgba(0,0,0,0.5)] relative">
    <!-- Header / Event Image -->
    <div class="h-48 bg-gray-200 relative">
      <img
        src="<?php echo htmlspecialchars($ticket['image_cover'] ?? 'https://placehold.co/800x300/000000/FFF?text=' . urlencode($ticket['event_title'] ?? 'Evento')); ?>"
        class="w-full h-full object-cover">
      <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent flex items-end p-6">
        <h1 class="text-3xl font-bold text-white"><?php echo htmlspecialchars($ticket['event_title'] ?? 'Evento'); ?>
        </h1>
      </div>
    </div>

    <div class="p-8">
      <div class="flex flex-col md:flex-row justify-between items-start gap-8">

        <!-- Info -->
        <div class="flex-1 space-y-4">
          <div>
            <p class="text-xs uppercase tracking-widest text-gray-500 font-bold mb-1">Participante</p>
            <p class="text-xl font-bold"><?php echo htmlspecialchars($ticket['user_name'] ?? 'Participante'); ?></p>
            <p class="text-sm text-gray-500"><?php echo htmlspecialchars($ticket['user_email'] ?? ''); ?></p>
          </div>

          <div class="grid grid-cols-2 gap-4">
            <div>
              <p class="text-xs uppercase tracking-widest text-gray-500 font-bold mb-1">Data</p>
              <p class="font-bold">
                <?php echo isset($ticket['start_date']) ? date('d/m/Y', strtotime($ticket['start_date'])) : 'Data a confirmar'; ?>
              </p>
              <p class="text-sm text-gray-500">
                <?php echo isset($ticket['start_date']) ? date('H:i', strtotime($ticket['start_date'])) : ''; ?>H
              </p>
            </div>
            <div>
              <p class="text-xs uppercase tracking-widest text-gray-500 font-bold mb-1">Tipo</p>
              <span
                class="inline-block bg-brand-secondary/10 text-brand-secondary px-2 py-1 rounded text-sm font-bold border border-brand-secondary/20">
                <?php echo htmlspecialchars($ticket['ticket_name'] ?? 'Ingresso'); ?>
              </span>
            </div>
          </div>

          <div>
            <p class="text-xs uppercase tracking-widest text-gray-500 font-bold mb-1">Local</p>
            <p class="text-sm font-medium">
              <?php echo htmlspecialchars($ticket['location'] ?? 'Local a definir'); ?>
            </p>
          </div>

        </div>

        <!-- QR Code & Status -->
        <div
          class="flex flex-col items-center justify-center bg-gray-50 p-6 rounded-2xl border-2 border-dashed border-gray-300 w-full md:w-auto">

          <?php if (($ticket['status'] ?? '') === 'active'): ?>
            <!-- Active: Show QR and Code -->
            <?php $code = $ticket['unique_code'] ?? 'UNKNOWN'; ?>
            <!-- Using Google Chart API for simpler direct image render or keep qrserver -->
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=<?php echo $code; ?>" alt="QR Code"
              class="w-32 h-32 mb-4 mix-blend-multiply" crossorigin="anonymous">

            <p class="font-mono text-lg font-bold tracking-widest text-gray-800">
              <?php echo implode(' ', str_split($code, 4)); ?>
            </p>

            <div class="mt-4">
              <span class="flex items-center text-green-600 font-bold text-sm uppercase tracking-wide">
                <span class="w-2 h-2 bg-green-500 rounded-full mr-2 animate-pulse"></span> Válido
              </span>
            </div>

          <?php elseif (($ticket['status'] ?? '') === 'pending' || ($ticket['status'] ?? '') === 'pending_payment'): ?>
            <!-- Pending: Hide QR -->
            <div class="w-32 h-32 mb-4 bg-gray-200 rounded flex items-center justify-center opacity-50">
              <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                </path>
              </svg>
            </div>
            <p class="font-mono text-lg font-bold tracking-widest text-gray-400">#### #### #### ####</p>

            <div class="mt-4">
              <span class="flex items-center text-yellow-600 font-bold text-sm uppercase tracking-wide">
                <span class="w-2 h-2 bg-yellow-500 rounded-full mr-2"></span> Aguardando Pagamento
              </span>
            </div>

          <?php elseif (($ticket['status'] ?? '') === 'used'): ?>
            <!-- Used: Show QR (maybe?) or Hide. Usually show for record, but grayed. -->
            <?php $code = $ticket['unique_code'] ?? 'UNKNOWN'; ?>
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=<?php echo $code; ?>" alt="QR Code"
              class="w-32 h-32 mb-4 mix-blend-multiply opacity-50 grayscale" crossorigin="anonymous">

            <p class="font-mono text-lg font-bold tracking-widest text-gray-500 line-through">
              <?php echo implode(' ', str_split($code, 4)); ?>
            </p>

            <div class="mt-4">
              <span class="flex items-center text-gray-500 font-bold text-sm uppercase tracking-wide">
                <span class="w-2 h-2 bg-gray-400 rounded-full mr-2"></span> Utilizado
              </span>
              <p class="text-[10px] text-gray-400 text-center mt-1">
                <?php echo isset($ticket['used_at']) ? date('d/m/Y H:i', strtotime($ticket['used_at'])) : ''; ?>
              </p>
            </div>

          <?php else: ?>
            <!-- Cancelled -->
            <div class="w-32 h-32 mb-4 bg-red-100 rounded flex items-center justify-center">
              <svg class="w-12 h-12 text-red-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
              </svg>
            </div>
            <p class="font-mono text-lg font-bold tracking-widest text-red-300 line-through">#### #### #### ####</p>

            <div class="mt-4">
              <span class="text-red-500 font-bold text-sm uppercase">Cancelado</span>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <hr class="my-8 border-gray-200">

      <div class="text-center flex flex-col items-center gap-4">
        <p class="text-xs text-gray-400">Apresente este código na entrada do evento. É obrigatória a apresentação
          de documento com foto.</p>
      </div>
    </div>

    <!-- Stub / Tear-off visual -->
    <div class="h-4 bg-gray-100 border-t border-dashed border-gray-300 relative">
      <div class="absolute -left-2 -top-2 w-4 h-4 rounded-full bg-brand-dark"></div>
      <div class="absolute -right-2 -top-2 w-4 h-4 rounded-full bg-brand-dark"></div>
    </div>
  </div>

  <div class="mt-8 flex flex-wrap justify-center gap-4 no-print">
    <button onclick="window.print()"
      class="bg-black hover:bg-gray-800 text-white font-bold py-3 px-8 rounded-full transition shadow-lg flex items-center justify-center">
      <i class="fas fa-print mr-2"></i>
      Imprimir
    </button>

    <button onclick="downloadTicket()"
      class="bg-brand-secondary hover:bg-brand-secondary/80 text-white font-bold py-3 px-8 rounded-full transition shadow-lg flex items-center justify-center">
      <i class="fas fa-download mr-2"></i>
      Baixar Ingresso
    </button>
  </div>
</div>

<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<script>
  function downloadTicket() {
    const ticketElement = document.getElementById('ticket-print-area');
    const downloadBtn = document.querySelector('button[onclick="downloadTicket()"]');
    const originalText = downloadBtn.innerHTML;

    downloadBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Gerando...';
    downloadBtn.disabled = true;

    // Use html2canvas
    html2canvas(ticketElement, {
      scale: 2, // Better resolution
      useCORS: true, // Allow external images (like QR code)
      backgroundColor: '#ffffff'
    }).then(canvas => {
      // Convert to image
      const image = canvas.toDataURL("image/png");

      // Trigger download
      const link = document.createElement('a');
      link.href = image;
      link.download = 'Ingresso-<?php echo $ticket['unique_code'] ?? 'Cevai'; ?>.png';
      link.click();

      // Restore button
      downloadBtn.innerHTML = originalText;
      downloadBtn.disabled = false;
    }).catch(err => {
      console.error(err);
      alert('Erro ao gerar imagem. Tente imprimir como PDF.');
      downloadBtn.innerHTML = originalText;
      downloadBtn.disabled = false;
    });
  }
</script>

<style>
  @media print {
    body * {
      visibility: hidden;
    }

    #ticket-print-area,
    #ticket-print-area * {
      visibility: visible;
    }

    #ticket-print-area {
      position: absolute !important;
      left: 0 !important;
      top: 0 !important;
      right: 0 !important;
      width: 100% !important;
      max-width: 21cm !important;
      /* A4 width limit */
      margin: 0 auto !important;
      padding: 0;
      box-shadow: none !important;
      border: none !important;
      border-radius: 0 !important;
      background: white !important;
    }

    .no-print {
      display: none !important;
    }

    /* Ensure background graphics are printed */
    * {
      -webkit-print-color-adjust: exact !important;
      print-color-adjust: exact !important;
    }
  }
</style>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>