<?php
$title = 'Meus Ingressos - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<!-- QR Code Library -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>

<div class="max-w-4xl mx-auto">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Meus Ingressos</h2>
        <div class="text-gray-600 dark:text-gray-400">
            Bem-vindo, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
        </div>
    </div>

    <!-- Alerts -->
    <?php if (isset($_GET['msg'])): ?>
        <?php if ($_GET['msg'] === 'compra_sucesso'): ?>
            <div
                class="bg-green-500/20 border border-green-500 text-green-800 dark:text-green-100 p-4 rounded mb-6 flex items-center">
                <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                <div>
                    <p class="font-bold">Compra realizada com sucesso!</p>
                    <p class="text-sm">Seu ingresso já está disponível abaixo.</p>
                </div>
            </div>
        <?php elseif ($_GET['msg'] === 'aguardando_pagamento'): ?>
            <div
                class="bg-yellow-500/20 border border-yellow-500 text-yellow-800 dark:text-yellow-100 p-4 rounded mb-6 flex items-center">
                <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <p class="font-bold">Pedido recebido! Aguardando pagamento.</p>
                    <p class="text-sm">Seu ingresso será liberado assim que o pagamento for confirmado.</p>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Tickets List -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <?php foreach ($tickets as $ticket): ?>
            <div
                class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-lg overflow-hidden group hover:border-brand-secondary dark:hover:border-brand-neon transition flex flex-col shadow-sm dark:shadow-none">
                <div
                    class="bg-gray-50 dark:bg-black p-4 border-b border-gray-200 dark:border-gray-800 flex justify-between items-center">
                    <span
                        class="font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($ticket['event_title']); ?></span>

                    <!-- Status Badge -->
                    <?php if ($ticket['status'] === 'active'): ?>
                        <span class="text-xs bg-green-500/20 text-green-400 px-2 py-1 rounded">Confirmado</span>
                    <?php elseif ($ticket['status'] === 'used'): ?>
                        <span class="text-xs bg-gray-600 text-gray-300 px-2 py-1 rounded">Utilizado</span>
                    <?php elseif ($ticket['status'] === 'cancelled'): ?>
                        <span class="text-xs bg-red-500/20 text-red-400 px-2 py-1 rounded">Cancelado</span>
                    <?php else: ?>
                        <span class="text-xs bg-yellow-500/20 text-yellow-400 px-2 py-1 rounded">Pendente</span>
                    <?php endif; ?>
                </div>
                <div class="p-6 flex-grow">
                    <div class="flex justify-between mb-4">
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Ingresso</p>
                            <p class="font-bold text-brand-secondary dark:text-brand-purple">
                                <?php echo htmlspecialchars($ticket['ticket_name']); ?>
                            </p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs text-gray-500 uppercase">Lote</p>
                            <p class="text-gray-900 dark:text-white"><?php echo htmlspecialchars($ticket['batch_name']); ?>
                            </p>
                        </div>
                    </div>
                    <div class="flex justify-between mb-6">
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Data</p>
                            <p class="text-gray-900 dark:text-white">
                                <?php echo date('d/m/Y H:i', strtotime($ticket['start_date'])); ?>
                            </p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs text-gray-500 uppercase">Local</p>
                            <p class="text-gray-900 dark:text-white"><?php echo htmlspecialchars($ticket['location']); ?>
                            </p>
                        </div>
                    </div>

                    <!-- QR Code Section (Only if Active) -->
                    <?php if ($ticket['status'] === 'active'): ?>
                        <div id="qr-<?php echo $ticket['id']; ?>" class="flex justify-center mb-4 p-2 bg-white rounded hidden">
                        </div>

                        <button onclick="toggleQr('<?php echo $ticket['id']; ?>', '<?php echo $ticket['unique_code']; ?>')"
                            class="w-full bg-gray-800 hover:bg-gray-700 text-white py-2 rounded border border-gray-700 transition">
                            Ver QR Code
                        </button>
                        <div class="text-center mt-2 text-xs text-gray-500">Code:
                            <?php echo htmlspecialchars($ticket['unique_code']); ?>
                        </div>
                    <?php elseif ($ticket['status'] === 'pending' || $ticket['status'] === 'pending_payment'): ?>
                        <?php
                        // Calculate expiry time (Created + 10 mins)
                        // Assuming created_at is available in $ticket. UserTicket::getByUserId query needs to ensure created_at is selected.
                        // The query in UserTicket.php selects `ut.*`, so created_at is present.
                        $createdAt = strtotime($ticket['created_at']);
                        $expiryTime = $createdAt + (10 * 60);
                        $timeLeft = $expiryTime - time();
                        ?>

                        <?php if ($timeLeft > 0): ?>
                            <div
                                class="bg-yellow-100 dark:bg-yellow-900/20 p-3 rounded text-center border border-yellow-200 dark:border-yellow-900/50">
                                <p class="text-yellow-700 dark:text-yellow-400 text-sm mb-1 font-bold">Aguardando Pagamento</p>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">Finalize o pagamento em:</p>
                                <div class="text-xl font-mono font-bold text-brand-secondary dark:text-brand-neon countdown-timer"
                                    data-expires="<?php echo $expiryTime; ?>">
                                    --:--
                                </div>
                                <a href="/checkout/payment/<?php echo $ticket['order_id']; ?>"
                                    class="mt-2 inline-block text-xs bg-brand-secondary dark:bg-brand-neon text-white dark:text-black px-3 py-1 rounded font-bold hover:brightness-110">Pagar
                                    Agora</a>
                            </div>
                        <?php else: ?>
                            <div class="bg-red-900/20 p-3 rounded text-center border border-red-900/50">
                                <p class="text-red-400 text-sm mb-1 font-bold">Expirado</p>
                                <p class="text-xs text-gray-400">Tempo limite excedido. Atualize a página.</p>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="text-center text-gray-500 text-sm py-2">Ingresso indisponível</div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>

        <?php if (empty($tickets)): ?>
            <div
                class="col-span-2 text-center py-12 text-gray-600 dark:text-gray-400 bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
                <p class="mb-4">Você ainda não tem ingressos.</p>
                <a href="/" class="text-brand-secondary dark:text-brand-neon hover:underline font-bold">Ir para a loja</a>
            </div>
        <?php endif; ?>
    </div>
</div>




<script>
    function toggleQr(ticketId, uniqueCode) {
        const qrContainer = document.getElementById('qr-' + ticketId);

        if (qrContainer.classList.contains('hidden')) {
            qrContainer.classList.remove('hidden');

            // Check if already generated
            if (qrContainer.innerHTML.trim() === '') {
                new QRCode(qrContainer, {
                    text: uniqueCode,
                    width: 128,
                    height: 128,
                    colorDark: "#000000",
                    colorLight: "#ffffff",
                    correctLevel: QRCode.CorrectLevel.H
                });
            }
        } else {
            qrContainer.classList.add('hidden');
        }
    }

    // Countdown Logic
    document.addEventListener('DOMContentLoaded', () => {
        const timers = document.querySelectorAll('.countdown-timer');
        timers.forEach(timer => {
            const expiry = parseInt(timer.dataset.expires) * 1000;

            const update = () => {
                const now = new Date().getTime();
                const distance = expiry - now;

                if (distance < 0) {
                    timer.innerHTML = "EXPIRADO";
                    timer.classList.add('text-red-500');
                    return;
                }

                const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                timer.innerHTML =
                    (minutes < 10 ? "0" + minutes : minutes) + ":" +
                    (seconds < 10 ? "0" + seconds : seconds);
            };

            update(); // Init
            setInterval(update, 1000);
        });
    });
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>