<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title><?php echo $subject ?? Helpers::getSiteName(); ?></title>
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f3f4f6;
      margin: 0;
      padding: 0;
      color: #1f2937;
    }

    .container {
      max-width: 600px;
      margin: 20px auto;
      background-color: #ffffff;
      border-radius: 8px;
      overflow: hidden;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .header {
      background-color: #ffffff;
      padding: 20px;
      text-align: center;
      border-bottom: 2px solid
        <?php echo $accentColor ?? '#e5e7eb'; ?>
      ;
    }

    .header h1 {
      color:
        <?php echo $mainColor ?? '#7000FF'; ?>
      ;
      margin: 0;
      font-size: 24px;
      text-transform: uppercase;
      letter-spacing: 2px;
    }

    .content {
      padding: 30px;
      line-height: 1.6;
    }

    .button {
      display: inline-block;
      background-color:
        <?php echo $mainColor ?? '#7000FF'; ?>
      ;
      color: #ffffff !important;
      padding: 12px 24px;
      text-decoration: none;
      border-radius: 4px;
      font-weight: bold;
      margin-top: 20px;
    }

    .button:hover {
      opacity: 0.9;
    }

    .footer {
      background-color: #f9fafb;
      padding: 20px;
      text-align: center;
      font-size: 12px;
      color: #6b7280;
      border-top: 1px solid #e5e7eb;
    }

    .footer a {
      color:
        <?php echo $mainColor ?? '#7000FF'; ?>
      ;
      text-decoration: none;
    }
  </style>
</head>

<body>
  <div class="container">
    <div class="header">
      <?php if (!empty($emailLogo)): ?>
        <?php
        $logoUrl = $emailLogo;
        // Ensure URL is absolute
        if (strpos($logoUrl, 'http') === false) {
          $baseUrl = defined('APP_URL') ? APP_URL : 'http://localhost:8000';
          $logoUrl = rtrim($baseUrl, '/') . '/' . ltrim($emailLogo, '/');
        }
        ?>
        <img src="<?php echo $logoUrl; ?>" alt="<?php echo $siteName ?? 'Site'; ?>"
          style="max-height: 80px; max-width: 250px; height: auto; border: 0; outline: none; text-decoration: none; display: block; margin: 0 auto;">
      <?php else: ?>
        <h1><?php echo isset($siteName) ? strtoupper($siteName) : 'SITE'; ?></h1>
      <?php endif; ?>
    </div>
    <div class="content">
      <?php echo $content; ?>
    </div>
    <div class="footer">
      <p>&copy; <?php echo date('Y'); ?> <?php echo isset($siteName) ? $siteName : Helpers::getSiteName(); ?>.</p>
      <p>Este é um email automático, por favor não responda.</p>
    </div>
  </div>
</body>

</html>