<?php
$title = 'Erro Interno';
?>
<!DOCTYPE html>
<html lang="pt-BR" class="dark">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo $title; ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          colors: {
            brand: {
              neon: '#CCFF00',
              secondary: '#1A1A1A'
            }
          }
        }
      }
    }
  </script>
</head>

<body class="bg-gray-100 dark:bg-black text-gray-900 dark:text-white flex items-center justify-center h-screen">
  <div class="text-center p-8">
    <h1 class="text-6xl font-bold text-red-500 mb-4">500</h1>
    <h2 class="text-2xl font-bold mb-4">Erro Interno do Servidor</h2>
    <p class="text-gray-500 dark:text-gray-400 mb-8 max-w-md mx-auto">
      Algo deu errado do nosso lado. Estamos trabalhando para corrigir isso.
    </p>
    <a href="/"
      class="bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold py-3 px-8 rounded hover:brightness-110 transition">
      TENTAR NOVAMENTE
    </a>
  </div>
</body>

</html>