<?php require_once APP_PATH . '/views/partials/header.php'; ?>

<!-- Hero -->
<header class="py-20 text-center relative overflow-hidden bg-white dark:bg-transparent transition-colors duration-300">
  <div class="absolute inset-0 bg-gradient-to-b from-transparent to-gray-50 dark:to-brand-dark opacity-50 z-0"></div>
  <div class="container mx-auto relative z-10 px-4">
    <h1 class="text-5xl md:text-7xl font-bold mb-4 neon-text text-gray-900 dark:text-white">
      <?php echo htmlspecialchars($settings['agenda_hero_title'] ?? 'O Futuro dos Eventos Tech'); ?>
    </h1>
    <p class="text-xl text-gray-600 dark:text-gray-400 mb-8 max-w-2xl mx-auto">
      <?php echo htmlspecialchars($settings['agenda_hero_subtitle'] ?? 'Garanta seu lugar nas maiores imersões de tecnologia e inteligência artificial.'); ?>
    </p>
    <a href="#events"
      class="bg-brand-neon text-black font-bold px-8 py-3 rounded-full hover:shadow-[0_0_20px_rgba(0,243,255,0.5)] transition">Ver
      Eventos</a>
  </div>
</header>

<!-- Events Grid -->
<section id="events"
  class="py-8 md:py-16 container mx-auto px-2 md:px-4 bg-gray-50 dark:bg-black transition-colors duration-300">
  <h2 class="text-3xl font-bold mb-8 border-l-4 border-brand-purple pl-4 text-gray-900 dark:text-white">Próximos Eventos
  </h2>

  <?php if (empty($events)): ?>
    <div class="text-center text-gray-500 py-10">
      <p>Nenhum evento encontrado no momento.</p>
    </div>
  <?php else: ?>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-8">
      <?php foreach ($events as $event): ?>
        <div
          class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-lg overflow-hidden hover:scale-105 transition duration-300 shadow-md">
          <img src="<?php echo htmlspecialchars($event['image_cover'] ?? 'https://placehold.co/400x200?text=Evento'); ?>"
            alt="" class="w-full h-48 object-cover">
          <div class="p-6">
            <h3 class="text-xl font-bold mb-2 text-gray-900 dark:text-white">
              <?php echo htmlspecialchars($event['title']); ?>
            </h3>
            <div class="text-gray-600 dark:text-gray-400 text-sm mb-4">
              <p>📅 <?php echo date('d/m/Y H:i', strtotime($event['start_date'])); ?></p>
              <p>📍 <?php echo htmlspecialchars($event['location']); ?></p>
            </div>
            <a href="/event/<?php echo $event['slug']; ?>"
              class="block text-center w-full bg-brand-neon/10 border border-brand-neon text-brand-neon font-bold py-2 rounded hover:bg-brand-neon hover:text-black transition">COMPRAR
              INGRESSO</a>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</section>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>