<?php
$title = 'Scanner de Check-in - Cê Vai';
// Simplified header for operator focus? Or standard header? Standard is fine.
require_once APP_PATH . '/views/partials/header.php';

// Safe access to event title
$evtTitle = isset($event) ? $event['title'] : 'Check-in';
$evtId = isset($event) ? $event['id'] : '#';
?>

<div class="max-w-xl mx-auto py-8 px-4">

  <div class="mb-6 flex items-center justify-between">
    <a href="/operator/dashboard"
      class="text-gray-500 hover:text-gray-900 dark:hover:text-white flex items-center gap-2">
      <i class="fas fa-arrow-left"></i> Voltar
    </a>
    <h2 class="text-xl font-bold text-gray-800 dark:text-white text-right truncate w-2/3">
      <?php echo htmlspecialchars($evtTitle); ?>
    </h2>
  </div>

  <!-- Stats Counter -->
  <div class="bg-brand-neon/10 border border-brand-neon/20 rounded-xl p-4 mb-6 flex items-center justify-between">
    <div class="flex items-center gap-3">
      <div class="w-10 h-10 rounded-full bg-brand-neon flex items-center justify-center text-black font-bold">
        <i class="fas fa-users"></i>
      </div>
      <div>
        <p class="text-sm text-gray-500 dark:text-gray-400 font-bold uppercase">Confirmados</p>
        <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo $total_checkins ?? 0; ?></p>
      </div>
    </div>
    <div class="text-right">
      <span class="text-xs bg-green-500/20 text-green-500 px-2 py-1 rounded font-bold uppercase">Ao Vivo</span>
    </div>
  </div>

  <div class="bg-white dark:bg-gray-900 p-6 rounded-xl border border-gray-200 dark:border-gray-800 shadow-xl">

    <?php if (isset($success) && $success): ?>
      <div
        class="bg-green-100 dark:bg-green-900/30 border border-green-500 text-green-700 dark:text-green-300 p-6 rounded-xl mb-6 text-center animate-pulse">
        <div class="w-16 h-16 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-3">
          <i class="fas fa-check text-3xl text-white"></i>
        </div>
        <h3 class="font-bold text-2xl mb-1">VALIDADO!</h3>
        <p class="text-lg font-medium"><?php echo htmlspecialchars($ticket['user_name']); ?></p>
        <p class="text-sm opacity-75"><?php echo htmlspecialchars($ticket['ticket_name']); ?></p>
      </div>
    <?php elseif (isset($error)): ?>
      <div
        class="bg-red-100 dark:bg-red-900/30 border border-red-500 text-red-700 dark:text-red-300 p-6 rounded-xl mb-6 text-center">
        <div class="w-16 h-16 bg-red-500 rounded-full flex items-center justify-center mx-auto mb-3">
          <i class="fas fa-times text-3xl text-white"></i>
        </div>
        <h3 class="font-bold text-2xl mb-1">ERRO!</h3>
        <p class="text-lg"><?php echo htmlspecialchars($error); ?></p>
      </div>
    <?php endif; ?>

    <!-- Scanner Area -->
    <div class="mb-6 relative">
      <div id="reader" class="rounded-lg overflow-hidden border border-gray-700 bg-black min-h-[300px] relative hidden">
        <video id="qr-video" class="w-full h-full object-cover"></video>
        <div class="absolute inset-0 flex items-center justify-center pointer-events-none">
          <div class="w-64 h-64 border-2 border-brand-neon rounded-lg opacity-50 relative">
            <div class="absolute top-0 left-0 w-4 h-4 border-t-4 border-l-4 border-brand-neon -mt-1 -ml-1"></div>
            <div class="absolute top-0 right-0 w-4 h-4 border-t-4 border-r-4 border-brand-neon -mt-1 -mr-1"></div>
            <div class="absolute bottom-0 left-0 w-4 h-4 border-b-4 border-l-4 border-brand-neon -mb-1 -ml-1"></div>
            <div class="absolute bottom-0 right-0 w-4 h-4 border-b-4 border-r-4 border-brand-neon -mb-1 -mr-1"></div>
          </div>
        </div>
        <div
          class="absolute bottom-4 left-0 right-0 text-center text-white text-sm font-bold shadow-black drop-shadow-md">
          Aponte para o QR Code
        </div>
      </div>

      <div id="scan-controls" class="text-center mt-4">
        <button id="start-scan" type="button"
          class="w-full bg-gray-800 text-white px-6 py-4 rounded-xl flex items-center justify-center gap-3 hover:bg-gray-700 transition shadow-lg">
          <i class="fas fa-camera text-2xl"></i>
          <span class="font-bold text-lg">ABRIR CÂMERA</span>
        </button>
        <button id="stop-scan" type="button"
          class="hidden bg-red-600 text-white px-6 py-2 rounded-lg items-center gap-2 mx-auto hover:bg-red-700 transition w-full justify-center">
          Parar Câmera
        </button>
        <p id="camera-error" class="text-red-500 mt-2 hidden text-sm font-bold bg-red-100 p-2 rounded"></p>
      </div>
    </div>

    <!-- Manual Input Form -->
    <form action="/operator/checkin/process" method="POST" class="space-y-4">
      <?php echo Helpers::csrf_field(); ?>
      <div>
        <label class="block text-gray-500 text-sm font-bold mb-2 text-center uppercase tracking-wide">Ou digite o
          código</label>
        <input type="text" id="ticketCode" name="code" placeholder="TICKET-XXXXXX"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-lg p-4 text-gray-900 dark:text-white text-center text-2xl uppercase tracking-widest outline-none focus:border-brand-neon focus:ring focus:ring-brand-neon/50 transition">
      </div>
      <button type="submit"
        class="w-full bg-brand-neon text-black font-bold py-4 rounded-lg hover:bg-cyan-400 transition transform active:scale-95 shadow-lg">
        VALIDAR MANUALMENTE
      </button>
    </form>

  </div>
</div>

<script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    // Only init scanner if reader element exists (it does)
    const html5QrCode = new Html5Qrcode("reader");
    const startBtn = document.getElementById('start-scan');
    const stopBtn = document.getElementById('stop-scan');
    const readerEl = document.getElementById('reader');
    const errorMsg = document.getElementById('camera-error');
    const ticketInput = document.getElementById('ticketCode');

    const isLocalhost = window.location.hostname === 'localhost' || window.location.hostname === '127.0.0.1';
    const isHttps = window.location.protocol === 'https:';

    if (!isHttps && !isLocalhost) {
      errorMsg.innerHTML = '<strong class="block mb-1">⚠️ Câmera Indisponível (HTTPS Necessário)</strong>' +
        'Por motivos de segurança, os navegadores bloqueiam o acesso à câmera em conexões não seguras (HTTP).<br>' +
        'Acesse este sistema usando <strong>HTTPS</strong> ou use o Check-in Manual abaixo.';
      errorMsg.classList.remove('hidden');
      errorMsg.classList.add('bg-yellow-100', 'text-yellow-800', 'border', 'border-yellow-400'); // Warning style
      startBtn.disabled = true;
      startBtn.classList.add('opacity-50', 'cursor-not-allowed');
      // Hide button text to discourage clicking? No, keep it disabled.
      return;
    }

    startBtn.addEventListener('click', () => {
      // Basic support check
      if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
        errorMsg.textContent = "Seu navegador não suporta acesso à câmera (ou conexão não segura).";
        errorMsg.classList.remove('hidden');
        return;
      }

      errorMsg.classList.add('hidden');
      readerEl.classList.remove('hidden');

      const config = { fps: 10, qrbox: { width: 250, height: 250 } };

      html5QrCode.start(
        { facingMode: "environment" },
        config,
        (decodedText, decodedResult) => {
          // Success
          const audio = new Audio('https://assets.mixkit.co/active_storage/sfx/2573/2573-preview.mp3');
          audio.play().catch(e => { });

          ticketInput.value = decodedText;

          stopScanning().then(() => {
            document.querySelector('form').submit();
          });
        },
        (errorMessage) => {
          // ignore parsing error
        }
      ).then(() => {
        startBtn.classList.add('hidden');
        stopBtn.classList.remove('hidden');
        stopBtn.style.display = 'flex';
      }).catch((err) => {
        console.error("Camera Error:", err);
        readerEl.classList.add('hidden');

        let customMsg = "Erro ao acessar câmera.";
        if (err.name === 'NotAllowedError') {
          customMsg = "Permissão de câmera negada. Verifique as configurações do navegador.";
        } else if (err.name === 'NotFoundError') {
          customMsg = "Nenhuma câmera encontrada.";
        } else if (err.name === 'NotReadableError') {
          customMsg = "A câmera pode estar em uso por outro aplicativo.";
        } else if (err.name === 'OverconstrainedError') {
          customMsg = "Câmera traseira não encontrada/disponível.";
        } else if (window.isSecureContext === false) {
          customMsg = "Câmera requer HTTPS (Conexão Segura).";
        }

        errorMsg.textContent = `${customMsg} (${err.name}: ${err.message})`;
        errorMsg.classList.remove('hidden');
      });
    });

    stopBtn.addEventListener('click', stopScanning);

    function stopScanning() {
      return html5QrCode.stop().then(() => {
        readerEl.classList.add('hidden');
        startBtn.classList.remove('hidden');
        stopBtn.classList.add('hidden');
      }).catch((err) => {
        console.log("Failed to stop.", err);
      });
    }
  });
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>