<?php
$title = 'Painel do Operador - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto py-8 px-4">
  <div class="flex items-center justify-between mb-8">
    <h2 class="text-3xl font-bold text-gray-900 dark:text-white">Meus Eventos</h2>
    <span class="bg-gray-100 dark:bg-gray-800 text-gray-600 dark:text-gray-300 px-3 py-1 rounded-full text-sm">
      Operador: <?php echo htmlspecialchars($_SESSION['user_name']); ?>
    </span>
  </div>

  <?php if (empty($events)): ?>
    <div
      class="bg-white dark:bg-gray-900 rounded-xl p-12 text-center shadow-lg border border-gray-100 dark:border-gray-800">
      <div class="bg-gray-100 dark:bg-gray-800 w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-6">
        <i class="fas fa-calendar-times text-3xl text-gray-400"></i>
      </div>
      <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Nenhum evento atribuído</h3>
      <p class="text-gray-500">Você ainda não foi vinculado a nenhum evento para realizar check-in.</p>
    </div>
  <?php else: ?>
    <div class="grid gap-6">
      <?php foreach ($events as $event): ?>
        <div
          class="bg-white dark:bg-gray-900 rounded-xl overflow-hidden shadow-lg border border-gray-100 dark:border-gray-800 flex flex-col md:flex-row hover:shadow-xl transition group">

          <div class="w-full md:w-48 h-48 md:h-auto bg-gray-200 shrink-0 relative">
            <img
              src="<?php echo !empty($event['image_cover']) ? $event['image_cover'] : '/assets/images/event-placeholder.jpg'; ?>"
              alt="<?php echo htmlspecialchars($event['title']); ?>" class="w-full h-full object-cover">
            <div
              class="absolute inset-0 bg-black/50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition duration-300">
              <i class="fas fa-qrcode text-4xl text-white"></i>
            </div>
          </div>

          <div class="p-6 flex-1 flex flex-col justify-between">
            <div>
              <div class="flex justify-between items-start">
                <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-2 group-hover:text-brand-neon transition">
                  <?php echo htmlspecialchars($event['title']); ?>
                </h3>
                <span class="bg-brand-neon text-black text-xs font-bold px-2 py-1 rounded">
                  <?php echo date('d/m/Y', strtotime($event['start_date'])); ?>
                </span>
              </div>
              <p class="text-gray-500 dark:text-gray-400 mb-4 flex items-center gap-2">
                <i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($event['location']); ?>
              </p>
            </div>

            <div class="mt-4">
              <a href="/operator/event/<?php echo $event['id']; ?>/checkin"
                class="block w-full text-center bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold py-3 rounded-lg hover:brightness-110 transition shadow-md">
                <i class="fas fa-qrcode mr-2"></i> INICIAR CHECK-IN
              </a>
            </div>
          </div>

        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>