<?php
$title = 'Aviso de Privacidade - ' . Helpers::getSiteName();
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto py-12 px-6">
    <h1 class="text-4xl font-bold mb-8 text-brand-secondary dark:text-brand-neon">Política de Privacidade</h1>

    <div class="space-y-8 text-gray-700 dark:text-gray-300 leading-relaxed text-justify">
        <p>A sua privacidade é prioridade para o <strong><?php echo Helpers::getSiteName(); ?></strong>. Esta Política
            de Privacidade descreve como
            coletamos, usamos, armazenamos e protegemos suas informações pessoais, em conformidade com a Lei Geral de
            Proteção de Dados (LGPD).</p>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                1. Dados Coletados</h2>
            <p>Para prestar nossos serviços de venda de ingressos, podemos coletar os seguintes dados:</p>
            <ul class="list-disc pl-5 mt-2 space-y-2">
                <li><strong>Dados de Identificação:</strong> Nome completo, CPF, data de nascimento.</li>
                <li><strong>Dados de Contato:</strong> Endereço de e-mail, número de telefone (WhatsApp).</li>
                <li><strong>Dados Financeiros:</strong> Informações de pagamento processadas por gateways parceiros
                    (Asaas, Mercado Pago, etc.). <em>Nota: O Cê Vai não armazena dados completos do seu cartão de
                        crédito.</em></li>
                <li><strong>Dados de Navegação:</strong> Endereço IP, tipo de dispositivo, navegador e páginas
                    acessadas.</li>
            </ul>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                2. Finalidade do Tratamento</h2>
            <p>Utilizamos seus dados para:</p>
            <ul class="list-disc pl-5 mt-2 space-y-2">
                <li>Processar a compra e emitir seus ingressos.</li>
                <li>Enviar confirmações, ingressos e atualizações sobre os eventos.</li>
                <li>Prevenir fraudes e garantir a segurança da plataforma.</li>
                <li>Cumprir obrigações legais e fiscais.</li>
                <li>Melhorar a experiência do usuário e oferecer suporte técnico.</li>
            </ul>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                3. Compartilhamento de Dados</h2>
            <p>Seus dados podem ser compartilhados com:</p>
            <ul class="list-disc pl-5 mt-2 space-y-2">
                <li><strong>Organizadores do Evento:</strong> Para fins de gestão da lista de participantes, controle de
                    acesso e comunicação direta sobre o evento adquirido.</li>
                <li><strong>Processadores de Pagamento:</strong> Para viabilizar a transação financeira.</li>
                <li><strong>Autoridades:</strong> Quando solicitado legalmente ou para proteção de direitos.</li>
            </ul>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                4. Armazenamento e Segurança</h2>
            <p>Adotamos medidas técnicas e administrativas de segurança para proteger seus dados contra acessos não
                autorizados, perdas ou alterações. Seus dados são armazenados em servidores seguros e mantidos pelo
                tempo necessário para cumprir as finalidades desta política.</p>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                5. Seus Direitos (LGPD)</h2>
            <p>Você tem direito a:</p>
            <ul class="list-disc pl-5 mt-2 space-y-2">
                <li>Confirmar a existência de tratamento de seus dados.</li>
                <li>Acessar seus dados.</li>
                <li>Corrigir dados incompletos ou desatualizados.</li>
                <li>Solicitar a exclusão de seus dados (exceto quando a manutenção for necessária por lei).</li>
            </ul>
            <p class="mt-4">Para exercer seus direitos, entre em contato através do e-mail de suporte disponível na
                página inicial.</p>
        </section>

        <div class="mt-12 border-t border-gray-800 pt-8 flex justify-between items-center">
            <p class="text-sm text-gray-500">Última atualização: <?php echo date('d/m/Y'); ?></p>
            <a href="/" class="text-brand-purple hover:text-brand-neon transition font-bold text-lg">&larr; Voltar para
                a Home</a>
        </div>
    </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>