<?php
$title = 'Termos de Uso - ' . Helpers::getSiteName();
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto py-12 px-6">
    <h1 class="text-4xl font-bold mb-8 text-brand-secondary dark:text-brand-neon">Termos de Uso</h1>

    <div class="space-y-8 text-gray-700 dark:text-gray-300 leading-relaxed text-justify">
        <p>Bem-vindo ao <strong><?php echo Helpers::getSiteName(); ?></strong>! Agradecemos por utilizar nossa
            plataforma. Ao acessar, navegar ou
            realizar compras em nosso site, você concorda em cumprir e sujeitar-se aos seguintes Termos e Condições de
            Uso. Leia-os atentamente.</p>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                1. Definições Iniciais</h2>
            <ul class="list-disc pl-5 space-y-2">
                <li><strong>Plataforma:</strong> Refere-se ao sistema "<?php echo Helpers::getSiteName(); ?>", acessível
                    via web, responsável pela
                    intermediação da venda de ingressos.</li>
                <li><strong>Usuário/Comprador:</strong> Pessoa física ou jurídica que navega na plataforma ou adquire
                    ingressos.</li>
                <li><strong>Organizador:</strong> Responsável pela criação, planejamento e execução do evento, bem como
                    pela definição de preços e regras de acesso.</li>
            </ul>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                2. Responsabilidades do Cê Vai</h2>
            <p>O <?php echo Helpers::getSiteName(); ?> atua exclusivamente como intermediário na venda de ingressos,
                fornecendo a tecnologia necessária
                para que Organizadores divulguem eventos e Usuários comprem ingressos.</p>
            <p class="mt-2">O Cê Vai <strong>NÃO</strong> é responsável por:</p>
            <ul class="list-disc pl-5 mt-2 space-y-2">
                <li>Realização, adimento ou cancelamento do evento.</li>
                <li>Qualidade, segurança ou estrutura do evento.</li>
                <li>Alterações na programação, local ou horário feitas pelo Organizador.</li>
            </ul>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                3. Compra de Ingressos</h2>
            <p>A compra de ingressos está sujeita à aprovação do pagamento pelas instituições financeiras e operadoras
                de cartão. A disponibilização do ingresso (QR Code) ocorrerá somente após a confirmação integral do
                pagamento.</p>
            <p class="mt-2">É de responsabilidade do Usuário fornecer dados corretos e verdadeiros no momento da compra.
                O Cê Vai não se responsabiliza por ingressos não recebidos devido a erros de digitação de e-mail ou
                outras informações.</p>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                4. Cancelamento e Reembolso</h2>
            <p>Conforme o Código de Defesa do Consumidor (Art. 49), o Usuário tem o direito de solicitar o cancelamento
                da compra em até <strong>7 (sete) dias corridos</strong> após a compra, desde que a solicitação seja
                feita até 48 horas antes do início do evento.</p>
            <p class="mt-2 text-yellow-600 dark:text-yellow-400">Após o prazo de 7 dias ou nas 48 horas que antecedem o
                evento, não serão aceitos pedidos de cancelamento ou reembolso, exceto em caso de cancelamento do
                próprio evento pelo Organizador.</p>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                5. Acesso ao Evento</h2>
            <p>O ingresso é um título ao portador ou nominal, dependendo da configuração do evento. É obrigatória a
                apresentação do ingresso (impresso ou no celular) e, se solicitado, de um documento de identidade com
                foto para acesso ao evento.</p>
            <p class="mt-2">O Organizador do evento tem o direito de negar o acesso a qualquer pessoa que não cumpra as
                regras do local ou que apresente comportamento inadequado.</p>
        </section>

        <section>
            <h2
                class="text-2xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                6. Propriedade Intelectual</h2>
            <p>Todo o conteúdo da plataforma (layout, marcas, software, banco de dados) é de propriedade exclusiva do Cê
                Vai ou de seus parceiros, sendo vedada a reprodução total ou parcial sem autorização expressa.</p>
        </section>

        <div class="mt-12 border-t border-gray-800 pt-8 flex justify-between items-center">
            <p class="text-sm text-gray-500">Última atualização: <?php echo date('d/m/Y'); ?></p>
            <a href="/" class="text-brand-purple hover:text-brand-neon transition font-bold text-lg">&larr; Voltar para
                a Home</a>
        </div>
    </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>