</main>

<?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
  </div> <!-- End Flex Wrapper -->
<?php endif; ?>

<footer
  class="bg-gray-100 dark:bg-black border-t border-gray-200 dark:border-gray-800 py-6 text-center text-gray-500 dark:text-gray-600 text-sm transition-colors duration-300">
  <p>&copy; <?php echo date('Y'); ?> <?php echo Helpers::getSiteName(); ?>. Todos os direitos reservados.</p>
  <div class="mt-2 space-x-4">
    <a href="/terms" class="hover:text-brand-neon transition">Termos de Uso</a>
    <a href="/privacy" class="hover:text-brand-neon transition">Política de Privacidade</a>
    <a href="/politica-reembolso" class="hover:text-brand-neon transition">Política de Reembolso</a>
    <a href="/contact" class="hover:text-brand-neon transition">Fale Conosco</a>
  </div>
</footer>

<script>
  // Mobile Menu Logic
  const adminBtn = document.getElementById('admin-mobile-btn');
  const clientBtn = document.getElementById('client-mobile-btn');
  const sidebar = document.getElementById('admin-sidebar');
  const overlay = document.getElementById('sidebar-overlay');
  const clientMenu = document.getElementById('client-mobile-menu');

  function toggleSidebar() {
    if (sidebar) {
      sidebar.classList.toggle('-translate-x-full');
      overlay.classList.toggle('hidden');
    }
  }

  function toggleClientMenu() {
    if (clientMenu) {
      clientMenu.classList.toggle('hidden');
    }
  }

  if (adminBtn) {
    adminBtn.addEventListener('click', toggleSidebar);
  }
  if (clientBtn) {
    clientBtn.addEventListener('click', toggleClientMenu);
  }

  // Countdown Timer Logic
  document.addEventListener('DOMContentLoaded', function () {
    const timers = document.querySelectorAll('.countdown-timer');

    if (timers.length === 0) return;

    const updateTimers = () => {
      const now = Math.floor(Date.now() / 1000);
      let activeTimers = 0;

      timers.forEach(timer => {
        const expires = parseInt(timer.dataset.expires);
        const diff = expires - now;

        if (diff <= 0) {
          timer.innerHTML = "00:00";
          timer.classList.add('text-red-500');
          // Optional: Auto-reload or change status UI
          // if (diff < -5) location.reload(); // Reload after 5s of expiry to show Cancelled status
        } else {
          activeTimers++;
          const m = Math.floor(diff / 60);
          const s = diff % 60;
          timer.innerHTML = `${m.toString().padStart(2, '0')}:${s.toString().padStart(2, '0')}`;
        }
      });
    };

    updateTimers(); // Initial run
    setInterval(updateTimers, 1000);
  });
</script>
</body>

</html>