<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php
  // --- Dynamic Settings: Colors & SEO ---
  $settings = [
    'color_brand_neon' => '#00F3FF',
    'color_brand_secondary' => '#7000FF',
    'seo_title_suffix' => ' | ' . (defined('APP_NAME') ? APP_NAME : 'Cê Vai'),
    'seo_description_default' => 'Plataforma de eventos',
    'seo_keywords_default' => 'eventos, ingressos'
  ];

  try {
    if (file_exists(APP_PATH . '/models/Setting.php')) {
      require_once APP_PATH . '/models/Setting.php';
      if (class_exists('Setting')) {
        $settingModel = new Setting();
        $dbSettings = $settingModel->getAllAsArray();
        $settings = array_merge($settings, $dbSettings);
      }
    }
  } catch (Exception $e) {
  }

  // --- Smart SEO Logic ---
  // Title
  $pageTitle = $title ?? 'Cê Vai';
  // If title doesn't already end with suffix, append it
  if (strpos($pageTitle, $settings['seo_title_suffix']) === false) {
    $pageTitle .= " " . $settings['seo_title_suffix'];
  }

  // Description & Keywords
  $seoDesc = $settings['seo_description_default'];
  $seoKeywords = $settings['seo_keywords_default'];

  // Logic to detect if we are on an Event Page (checking if $event data exists in scope)
  // Note: In views, variables are extracted. We check local variables.
  if (isset($event) && is_array($event) && isset($event['description'])) {
    // It's an event page
    // Strip tags for meta description
    $cleanDesc = strip_tags($event['description']);
    $seoDesc = mb_substr($cleanDesc, 0, 160) . '...';
  } elseif (isset($data) && isset($data['event']) && isset($data['event']['description'])) {
    // Alternative data structure
    $cleanDesc = strip_tags($data['event']['description']);
    $seoDesc = mb_substr($cleanDesc, 0, 160) . '...';
  }
  ?>

  <title><?php echo htmlspecialchars($pageTitle); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($seoDesc); ?>">
  <meta name="keywords" content="<?php echo htmlspecialchars($seoKeywords); ?>">

  <!-- Favicon -->
  <?php if (!empty($settings['site_favicon'])): ?>
    <link rel="icon" href="<?php echo htmlspecialchars($settings['site_favicon']); ?>">
  <?php endif; ?>

  <?php
  $ogImage = '';
  if (!empty($settings['site_logo'])) {
    $ogImage = $settings['site_logo'];
  }
  if (isset($event['image_cover']) && !empty($event['image_cover'])) {
    $ogImage = $event['image_cover'];
  } elseif (isset($data['event']['image_cover']) && !empty($data['event']['image_cover'])) {
    $ogImage = $data['event']['image_cover'];
  }

  // Ensure full URL for OG Image
  if ($ogImage && strpos($ogImage, 'http') === false) {
    $baseUrl = defined('APP_URL') ? APP_URL : '';
    $ogImage = rtrim($baseUrl, '/') . '/' . ltrim($ogImage, '/');
  }
  ?>

  <!-- Open Graph -->
  <meta property="og:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
  <meta property="og:description" content="<?php echo htmlspecialchars($seoDesc); ?>">
  <meta property="og:type" content="website">
  <?php if ($ogImage): ?>
    <meta property="og:image" content="<?php echo htmlspecialchars($ogImage); ?>">
  <?php endif; ?>

  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <script>
    tailwind.config = {
      darkMode: 'class',
      theme: {
        extend: {
          colors: {
            brand: {
              dark: '#0a0a0a',
              neon: '<?php echo $settings['color_brand_neon']; ?>',
              secondary: '<?php echo $settings['color_brand_secondary']; ?>',
              purple: '<?php echo $settings['color_brand_secondary']; ?>', // Map purple to secondary for compat
            }
          }
        }
      }
    }
  </script>
  <style>
    body {
      font-family: 'Inter', sans-serif;
    }

    .neon-text {
      text-shadow: 0 0 10px rgba(0, 243, 255, 0.7);
    }

    /* Smooth transition for theme colors */
    body,
    div,
    nav,
    aside,
    table,
    tr,
    td,
    th {
      transition-property: background-color, border-color, color, fill, stroke;
      transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
      transition-duration: 300ms;
    }
  </style>
  <!-- Flatpickr -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/dark.css">
  <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
  <script src="https://npmcdn.com/flatpickr/dist/l10n/pt.js"></script>

  <script>
    // Theme Logic
    if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
      document.documentElement.classList.add('dark')
    } else {
      document.documentElement.classList.remove('dark')
    }

    function toggleTheme() {
      if (document.documentElement.classList.contains('dark')) {
        document.documentElement.classList.remove('dark');
        localStorage.theme = 'light';
      } else {
        document.documentElement.classList.add('dark');
        localStorage.theme = 'dark';
      }
    }
  </script>
</head>

<body
  class="bg-gray-100 dark:bg-brand-dark text-gray-900 dark:text-white min-h-screen flex flex-col font-sans transition-colors duration-300">

  <!-- Navbar Global -->
  <nav
    class="border-b border-gray-200 dark:border-gray-800 bg-white/80 dark:bg-gray-900/50 backdrop-blur-md sticky top-0 z-50 h-16">
    <div class="w-full px-4 md:px-6 h-full flex justify-between items-center relative">
      <div class="flex items-center">
        <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
          <button id="admin-mobile-btn" class="md:hidden text-gray-800 dark:text-white focus:outline-none mr-4">
            <i class="fas fa-bars text-xl"></i>
          </button>
        <?php endif; ?>

        <!-- Logo (Centered on Mobile, Left on Desktop) -->
        <a href="/"
          class="hover:opacity-80 transition absolute left-1/2 transform -translate-x-1/2 md:static md:transform-none md:mr-8 inline-block">
          <?php if (!empty($settings['site_logo'])): ?>
            <?php if (!empty($settings['site_logo_inverted'])): ?>
              <!-- Light Mode Logo -->
              <img src="<?php echo htmlspecialchars($settings['site_logo_inverted']); ?>"
                alt="<?php echo defined('APP_NAME') ? APP_NAME : 'Cê Vai'; ?>"
                class="w-[150px] md:w-[185px] h-[45px] md:h-[55px] object-contain block dark:hidden">
              <!-- Dark Mode Logo -->
              <img src="<?php echo htmlspecialchars($settings['site_logo']); ?>"
                alt="<?php echo defined('APP_NAME') ? APP_NAME : 'Cê Vai'; ?>"
                class="w-[150px] md:w-[185px] h-[45px] md:h-[55px] object-contain hidden dark:block">
            <?php else: ?>
              <img src="<?php echo htmlspecialchars($settings['site_logo']); ?>"
                alt="<?php echo defined('APP_NAME') ? APP_NAME : 'Cê Vai'; ?>"
                class="w-[150px] md:w-[185px] h-[45px] md:h-[55px] object-contain">
            <?php endif; ?>
          <?php else: ?>
            <span class="text-2xl font-bold italic tracking-tighter">
              <span class="text-brand-neon">CÊ</span> <span class="text-gray-900 dark:text-white">VAI</span>
            </span>
          <?php endif; ?>
        </a>
      </div>

      <!-- Desktop Menu -->
      <div class="hidden md:flex items-center space-x-6">
        <!-- Theme Toggle -->
        <button onclick="toggleTheme()"
          class="p-2 rounded-full text-gray-500 hover:bg-gray-200 dark:hover:bg-gray-800 transition focus:outline-none"
          title="Alternar Tema">
          <i class="fas fa-sun block dark:hidden text-yellow-500 text-lg"></i>
          <i class="fas fa-moon hidden dark:block text-brand-neon text-lg"></i>
        </button>

        <a href="/contact"
          class="text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-medium text-sm">Fale
          Conosco</a>
        <?php if (isset($_SESSION['user_id'])): ?>
          <div class="flex items-center space-x-4">
            <span class="text-gray-500 dark:text-gray-400 text-sm">Olá, <strong
                class="text-gray-900 dark:text-white"><?php echo htmlspecialchars($_SESSION['user_name']); ?></strong></span>
            <?php if ($_SESSION['user_role'] === 'client'): ?>
              <a href="/client/dashboard" class="text-brand-neon hover:underline text-sm font-bold">Meus Ingressos</a>
              <a href="/client/profile"
                class="text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white text-sm">Minha Conta</a>
            <?php endif; ?>
            <a href="/logout"
              class="text-red-500 hover:text-red-400 text-sm font-bold border border-red-500/30 px-3 py-1 rounded hover:bg-red-500/10 transition">Sair</a>
          </div>
        <?php else: ?>
          <div class="space-x-4">
            <a href="/login"
              class="text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-medium">Login</a>
            <a href="/register"
              class="bg-brand-neon text-black px-4 py-2 rounded font-bold hover:bg-cyan-400 transition">Criar Conta</a>
          </div>
        <?php endif; ?>
      </div>

      <!-- Mobile Controls (Right Side) -->
      <div class="flex items-center gap-4 md:hidden">
        <!-- Theme Toggle (Visible to All on Mobile) -->
        <button onclick="toggleTheme()" class="p-2 rounded-full text-gray-500 focus:outline-none">
          <i class="fas fa-sun block dark:hidden text-yellow-500"></i>
          <i class="fas fa-moon hidden dark:block text-brand-neon"></i>
        </button>

        <!-- Client Mobile Menu Button (Only for Non-Admins) -->
        <?php if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin'): ?>
          <button id="client-mobile-btn" class="text-gray-800 dark:text-white focus:outline-none p-2">
            <i class="fas fa-bars text-xl"></i>
          </button>
        <?php endif; ?>
      </div>
    </div>

    <!-- Mobile Menu Dropdown (Client/Guest) -->
    <div id="client-mobile-menu"
      class="hidden md:hidden bg-white dark:bg-gray-900 border-b border-gray-200 dark:border-gray-800 absolute top-16 left-0 w-full p-4 shadow-xl z-50">
      <?php if (isset($_SESSION['user_id'])): ?>
        <div class="border-b border-gray-200 dark:border-gray-800 pb-4 mb-4">
          <p class="text-gray-500 dark:text-gray-400 text-sm">Olá, <strong
              class="text-gray-900 dark:text-white"><?php echo htmlspecialchars($_SESSION['user_name']); ?></strong></p>
        </div>
        <div class="flex flex-col space-y-3">
          <a href="/client/dashboard" class="block text-brand-neon font-bold">Meus Ingressos</a>
          <a href="/client/profile" class="block text-gray-600 dark:text-gray-300">Minha Conta</a>
          <a href="/logout" class="block text-red-500">Sair</a>
        </div>
      <?php else: ?>
        <div class="flex flex-col space-y-4">
          <a href="/login"
            class="block text-gray-900 dark:text-white text-center py-2 border border-gray-300 dark:border-gray-700 rounded">Login</a>
          <a href="/register" class="block bg-brand-neon text-black text-center py-2 rounded font-bold">Criar Conta</a>
        </div>
      <?php endif; ?>
    </div>
  </nav>

  <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
    <!-- Admin Layout: Sidebar + Content -->
    <div class="flex flex-1 min-h-[calc(100vh-64px)] relative">
      <!-- Mobile Overlay -->
      <div id="sidebar-overlay" class="fixed inset-0 bg-black/50 z-30 hidden md:hidden glass-effect"
        onclick="toggleSidebar()"></div>

      <!-- Sidebar -->
      <aside id="admin-sidebar"
        class="w-64 bg-white dark:bg-gray-900 border-r border-gray-200 dark:border-gray-800 flex flex-col shadow-xl z-40 fixed inset-y-0 left-0 transform -translate-x-full md:translate-x-0 md:static md:flex transition-transform duration-300 h-full">
        <div class="p-6">
          <div class="flex justify-between items-center mb-6 md:hidden">
            <span class="text-brand-neon font-bold text-xl">Menu</span>
            <button onclick="toggleSidebar()" class="text-gray-500 dark:text-gray-400 text-2xl">&times;</button>
          </div>
          <h5 class="text-xs uppercase text-gray-400 dark:text-gray-500 font-bold tracking-wider mb-4 hidden md:block">
            Administração</h5>
          <nav class="space-y-2">
            <a href="/admin/dashboard"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i
                class="fas fa-chart-line w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Dashboard</span>
            </a>
            <a href="/admin/orders"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i
                class="fas fa-shopping-cart w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Pedidos</span>
            </a>
            <a href="/admin/events"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i
                class="fas fa-calendar-alt w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Eventos</span>
            </a>
            <a href="/admin/clients"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i class="fas fa-users w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Clientes</span>
            </a>
            <a href="/admin/operators"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i class="fas fa-id-badge w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Operadores</span>
            </a>
            <a href="/admin/reports"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i class="fas fa-file-alt w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Relatórios</span>
            </a>
            <a href="/admin/checkin"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i class="fas fa-qrcode w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Check-in</span>
            </a>
            <div class="h-px bg-gray-200 dark:bg-gray-800 my-2"></div>
            <a href="/admin/settings"
              class="flex items-center space-x-3 text-gray-600 dark:text-gray-300 hover:text-brand-neon hover:bg-gray-100 dark:hover:bg-gray-800 p-2 rounded transition group">
              <i class="fas fa-cog w-5 text-center group-hover:text-brand-neon text-gray-400 dark:text-gray-500"></i>
              <span>Configurações</span>
            </a>
            <div class="h-px bg-gray-200 dark:bg-gray-800 my-2"></div>
            <a href="/logout"
              class="flex items-center space-x-3 text-red-500 hover:text-red-400 hover:bg-red-500/10 p-2 rounded transition group">
              <i class="fas fa-sign-out-alt w-5 text-center"></i>
              <span>Sair</span>
            </a>
          </nav>
        </div>
      </aside>

      <!-- Main Content Area -->
      <main class="flex-1 p-4 md:p-8 bg-gray-50 dark:bg-black overflow-y-auto w-full">



      <?php else: ?>
        <!-- Public/Client Layout -->
        <main class="flex-grow container mx-auto px-2 md:px-4 py-4 md:py-8">
        <?php endif; ?>