<?php

// Define config (subset of app_config)
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

try {
  echo "Connecting to MySQL...\n";
  $dsn = "mysql:host=" . DB_HOST . ";charset=" . DB_CHARSET;
  $options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  ];
  $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);

  echo "Creating database 'cevai' if not exists...\n";
  $pdo->exec("CREATE DATABASE IF NOT EXISTS cevai");
  $pdo->exec("USE cevai");

  echo "Reading database.sql...\n";
  $sql = file_get_contents(__DIR__ . '/../database.sql');

  if (!$sql) {
    die("Error: Could not read database.sql\n");
  }

  echo "Executing schema...\n";
  // Split by semicolon (rough split) or just execute if supports multiple queries
  // PDO run multiple queries at once might require different handling or just running it.
  // Most drivers allow it.
  $pdo->exec($sql);

  echo "Database setup completed successfully.\n";

} catch (PDOException $e) {
  die("DB Error: " . $e->getMessage() . "\n");
}
