<?php
define('APP_PATH', __DIR__ . '/../app');
require_once APP_PATH . '/config/app_config.php';
require_once APP_PATH . '/config/database.php';

$database = new Database();
$db = $database->connect();

echo "Checking 'event_speakers' table...\n";
$stmt = $db->query("SELECT * FROM event_speakers");
$speakers = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($speakers)) {
  echo "No speakers found in database.\n";
} else {
  echo "Found " . count($speakers) . " speakers:\n";
  foreach ($speakers as $s) {
    echo "ID: {$s['id']}, EventID: {$s['event_id']}, Name: {$s['name']}, Topic: {$s['topic']}\n";
  }
}

echo "\nChecking 'events' table...\n";
$stmt = $db->query("SELECT id, title, slug FROM events");
$events = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($events as $e) {
  echo "Event ID: {$e['id']}, Title: {$e['title']}, Slug: {$e['slug']}\n";
}
