<?php
// Define app path if not defined, assuming we are in scripts/
define('APP_PATH', __DIR__ . '/../app');

// Correctly include config and database
require_once APP_PATH . '/config/app_config.php';
require_once APP_PATH . '/config/database.php';

echo "Connecting to database...\n";
$database = new Database();
$db = $database->connect();

try {
  echo "Attempting to add column 'social_whatsapp' to 'events' table...\n";
  $sql = "ALTER TABLE events ADD COLUMN social_whatsapp VARCHAR(255) DEFAULT NULL";
  $db->exec($sql);
  echo "SUCCESS: Column 'social_whatsapp' added successfully.\n";
} catch (PDOException $e) {
  if (strpos($e->getMessage(), 'Duplicate column') !== false || $e->getCode() == '42S21') {
    echo "INFO: Column 'social_whatsapp' already exists.\n";
  } else {
    echo "ERROR: " . $e->getMessage() . "\n";
  }
}
