<?php
define('APP_PATH', __DIR__ . '/../app');
require_once APP_PATH . '/config/app_config.php';
require_once APP_PATH . '/config/database.php';

$database = new Database();
$db = $database->connect();

echo "Creating 'event_speakers' table...\n";

$sql = "CREATE TABLE IF NOT EXISTS event_speakers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    event_id INT NOT NULL,
    name VARCHAR(255) NOT NULL,
    topic VARCHAR(255) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (event_id) REFERENCES events(id) ON DELETE CASCADE
)";

try {
  $db->exec($sql);
  echo "Table 'event_speakers' created successfully.\n";
} catch (PDOException $e) {
  echo "Error creating table: " . $e->getMessage() . "\n";
}
