<?php
require_once __DIR__ . '/../app/config/app_config.php';
require_once APP_PATH . '/config/database.php';

// Instantiate Database directly
$db = new Database();
$conn = $db->connect();

$pass = password_hash('admin123', PASSWORD_DEFAULT);
$email = 'admin@cevai.com';

// Check if exists
$stmt = $conn->prepare("SELECT id FROM users WHERE email = :email");
$stmt->bindParam(':email', $email);
$stmt->execute();

if ($stmt->fetch()) {
  echo "Updating existing admin...\n";
  $stmt = $conn->prepare("UPDATE users SET password = :pass, role = 'admin' WHERE email = :email");
} else {
  echo "Creating new admin...\n";
  $stmt = $conn->prepare("INSERT INTO users (name, email, password, role) VALUES ('Admin', :email, :pass, 'admin')");
}

$stmt->bindParam(':email', $email);
$stmt->bindParam(':pass', $pass);

if ($stmt->execute()) {
  echo "Admin setup success. Login: admin@cevai.com / admin123";
} else {
  echo "Error setting up admin.";
}
